/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.worldcreator.objects;

import ch.njol.skript.Skript;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.region.TaskUtils;
import com.shanebeestudios.skbee.api.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.util.TriState;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeeWorldCreator
implements Keyed {
    private static final boolean HAS_KEEP_SPAWN_LOADED = Skript.methodExists(WorldCreator.class, (String)"keepSpawnLoaded", (Class[])new Class[0]);
    private final String worldName;
    private NamespacedKey key;
    private WorldType worldType;
    private World.Environment environment;
    private String generatorSettings;
    private String generator;
    private ChunkGenerator chunkGenerator;
    private BiomeProvider biomeProvider;
    Optional<Boolean> genStructures;
    Optional<Boolean> hardcore;
    Optional<Boolean> keepSpawnLoaded;
    Optional<Boolean> loadOnStart = Optional.empty();
    private Location fixedSpawnLocation;
    boolean isLoaded;
    long seed = -1L;
    private World world;
    private boolean clone;
    private boolean saveClone;
    private static final boolean HAS_KEY = Skript.methodExists(WorldCreator.class, (String)"ofNameAndKey", (Class[])new Class[]{String.class, NamespacedKey.class});

    public BeeWorldCreator(@NotNull String worldName, @Nullable NamespacedKey key) {
        this.worldName = worldName;
        this.key = key;
        this.genStructures = Optional.empty();
        this.hardcore = Optional.empty();
        this.keepSpawnLoaded = Optional.empty();
    }

    public BeeWorldCreator(@NotNull World world, @NotNull String name, @Nullable NamespacedKey key, boolean clone) {
        this.worldName = name;
        this.key = key;
        this.worldType = world.getWorldType();
        this.environment = world.getEnvironment();
        this.genStructures = Optional.of(world.canGenerateStructures());
        this.hardcore = Optional.of(world.isHardcore());
        this.keepSpawnLoaded = Optional.of(world.getKeepSpawnInMemory());
        this.seed = world.getSeed();
        this.world = world;
        this.clone = clone;
    }

    @NotNull
    public String getWorldName() {
        return this.worldName;
    }

    @NotNull
    public NamespacedKey getKey() {
        if (this.key == null) {
            String key = this.worldName.toLowerCase(Locale.ROOT).replaceAll(" ", "_");
            this.key = NamespacedKey.minecraft((String)key);
        }
        return this.key;
    }

    public void setWorldType(WorldType worldType) {
        this.worldType = worldType;
    }

    public WorldType getWorldType() {
        return this.worldType;
    }

    public void setEnvironment(World.Environment environment) {
        this.environment = environment;
    }

    public World.Environment getEnvironment() {
        return this.environment;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setGeneratorSettings(String generatorSettings) {
        this.generatorSettings = generatorSettings;
    }

    public String getGeneratorSettings() {
        return this.generatorSettings;
    }

    public String getGenerator() {
        return this.generator;
    }

    public void setGenerator(String generator) {
        this.generator = generator;
    }

    public void setChunkGenerator(ChunkGenerator chunkGenerator) {
        this.chunkGenerator = chunkGenerator;
    }

    public void setBiomeProvider(BiomeProvider biomeProvider) {
        this.biomeProvider = biomeProvider;
    }

    public void setGenStructures(boolean genStructures) {
        this.genStructures = Optional.of(genStructures);
    }

    public boolean isGenStructures() {
        return this.genStructures.orElse(true);
    }

    public boolean isHardcore() {
        return this.hardcore.orElse(false);
    }

    public void setHardcore(boolean hardcore) {
        this.hardcore = Optional.of(hardcore);
    }

    public boolean isKeepSpawnLoaded() {
        return this.keepSpawnLoaded.orElse(true);
    }

    public void setKeepSpawnLoaded(boolean loaded) {
        this.keepSpawnLoaded = Optional.of(loaded);
    }

    public void setFixedSpawnLocation(Location fixedSpawnLocation) {
        this.fixedSpawnLocation = fixedSpawnLocation;
    }

    public boolean isLoadOnStart() {
        return this.loadOnStart.orElse(true);
    }

    public void setLoadOnStart(boolean loadOnStart) {
        this.loadOnStart = Optional.of(loadOnStart);
    }

    public boolean isSaveClone() {
        return this.saveClone;
    }

    public void setSaveClone(boolean saveClone) {
        this.saveClone = saveClone;
    }

    public CompletableFuture<World> loadWorld() {
        CompletableFuture<Object> creatorFuture = new CompletableFuture<WorldCreator>();
        CompletableFuture<World> worldFuture = new CompletableFuture<World>();
        if (this.world != null) {
            creatorFuture = this.clone ? this.cloneWorld() : this.copyWorld();
        } else {
            creatorFuture.complete(BeeWorldCreator.getWorldCreator(this.worldName, this.key));
        }
        ((CompletableFuture)creatorFuture.thenAccept(worldCreator -> {
            World world = null;
            if (this.worldType != null) {
                worldCreator.type(this.worldType);
            }
            if (this.environment != null) {
                worldCreator.environment(this.environment);
            }
            if (this.seed != -1L) {
                worldCreator.seed(this.seed);
            }
            if (this.generatorSettings != null) {
                worldCreator.generatorSettings(this.generatorSettings);
            }
            if (this.generator != null) {
                worldCreator.generator(this.generator);
            }
            if (this.fixedSpawnLocation != null) {
                if (this.chunkGenerator != null) {
                    ChunkGenerator patt0$temp = this.chunkGenerator;
                    if (patt0$temp instanceof com.shanebeestudios.skbee.api.generator.ChunkGenerator) {
                        com.shanebeestudios.skbee.api.generator.ChunkGenerator customChunkGenerator = (com.shanebeestudios.skbee.api.generator.ChunkGenerator)patt0$temp;
                        customChunkGenerator.setFixedSpawnLocation(this.fixedSpawnLocation);
                    }
                } else {
                    this.chunkGenerator = BeeWorldCreator.getDummyGenerator(this.fixedSpawnLocation);
                }
            }
            if (this.chunkGenerator != null) {
                worldCreator.generator(this.chunkGenerator);
            }
            if (this.biomeProvider != null) {
                worldCreator.biomeProvider(this.biomeProvider);
            }
            if (this.keepSpawnLoaded.isPresent() && HAS_KEEP_SPAWN_LOADED) {
                TriState state = this.keepSpawnLoaded.get() != false ? TriState.TRUE : TriState.FALSE;
                worldCreator.keepSpawnLoaded(state);
            }
            this.genStructures.ifPresent(arg_0 -> ((WorldCreator)worldCreator).generateStructures(arg_0));
            this.hardcore.ifPresent(arg_0 -> ((WorldCreator)worldCreator).hardcore(arg_0));
            try {
                world = worldCreator.createWorld();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Util.errorForAdmins("Failed to load world '%s' see console for more details.", this.worldName);
            }
            if (world != null) {
                if (this.worldType == null) {
                    this.worldType = world.getWorldType();
                }
                if (this.environment == null) {
                    this.environment = world.getEnvironment();
                }
                if (this.seed == -1L) {
                    this.seed = world.getSeed();
                }
                if (this.genStructures.isEmpty()) {
                    this.genStructures = Optional.of(world.canGenerateStructures());
                }
                if (this.hardcore.isEmpty()) {
                    this.hardcore = Optional.of(world.isHardcore());
                }
                if (this.keepSpawnLoaded.isPresent() && !HAS_KEEP_SPAWN_LOADED) {
                    this.keepSpawnLoaded.ifPresent(arg_0 -> ((World)world).setKeepSpawnInMemory(arg_0));
                }
            }
            SkBee.getPlugin().getBeeWorldConfig().saveWorldToFile(this);
            worldFuture.complete(world);
        })).exceptionally(t -> {
            throw Skript.exception((Throwable)t, (String[])new String[0]);
        });
        return worldFuture;
    }

    private CompletableFuture<WorldCreator> copyWorld() {
        CompletableFuture<WorldCreator> worldCreatorCompletableFuture = new CompletableFuture<WorldCreator>();
        WorldCreator worldCreator = BeeWorldCreator.getWorldCreator(this.worldName, this.key);
        worldCreator.copy(this.world);
        worldCreatorCompletableFuture.complete(worldCreator);
        return worldCreatorCompletableFuture;
    }

    private CompletableFuture<WorldCreator> cloneWorld() {
        File worldContainer = Bukkit.getWorldContainer();
        File worldDirectorToClone = this.world.getWorldFolder();
        String cloneName = this.worldName;
        if (this.isSaveClone()) {
            this.world.save();
        }
        CompletableFuture<WorldCreator> worldCompletableFuture = new CompletableFuture<WorldCreator>();
        TaskUtils.getGlobalScheduler().runTaskAsync(() -> {
            File cloneDirectory = new File(worldContainer, cloneName);
            if (worldDirectorToClone.exists()) {
                try {
                    for (File file : Objects.requireNonNull(worldDirectorToClone.listFiles())) {
                        String fileName = file.getName();
                        if (file.isDirectory()) {
                            FileUtils.copyDirectory((File)file, (File)new File(cloneDirectory, fileName));
                            continue;
                        }
                        if (fileName.contains("session") || fileName.contains("uid.dat")) continue;
                        FileUtils.copyFile((File)file, (File)new File(cloneDirectory, fileName));
                    }
                    WorldCreator creator = BeeWorldCreator.getWorldCreator(cloneName, this.key);
                    TaskUtils.getGlobalScheduler().runTaskLater(() -> worldCompletableFuture.complete(creator), 0L);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        return worldCompletableFuture;
    }

    private static WorldCreator getWorldCreator(@NotNull String name, @Nullable NamespacedKey key) {
        if (HAS_KEY && key != null) {
            return new WorldCreator(name, key);
        }
        return new WorldCreator(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WorldCreator{");
        sb.append("worldName='").append(this.worldName).append('\'');
        if (this.key != null) {
            sb.append(", key='").append(this.key).append('\'');
        }
        sb.append(", worldType=").append(this.worldType);
        sb.append(", environment=").append(this.environment);
        sb.append(", generatorSettings='").append(this.generatorSettings).append('\'');
        sb.append(", generator='").append(this.generator).append('\'');
        sb.append(", genStructures=").append(this.genStructures);
        sb.append(", hardcore=").append(this.hardcore);
        sb.append(", keepSpawnLoaded=").append(this.keepSpawnLoaded);
        sb.append(", seed=").append(this.seed);
        sb.append(", world=").append(this.world);
        sb.append(", clone=").append(this.clone);
        sb.append('}');
        return sb.toString();
    }

    private static ChunkGenerator getDummyGenerator(final Location fixedSpawnLocation) {
        return new ChunkGenerator(){

            public Location getFixedSpawnLocation(@NotNull World world, @NotNull Random random) {
                Location clone = fixedSpawnLocation.clone();
                clone.setWorld(world);
                return clone;
            }

            public boolean shouldGenerateNoise() {
                return true;
            }

            public boolean shouldGenerateSurface() {
                return true;
            }

            public boolean shouldGenerateCaves() {
                return true;
            }

            public boolean shouldGenerateMobs() {
                return true;
            }

            public boolean shouldGenerateDecorations() {
                return true;
            }

            public boolean shouldGenerateStructures() {
                return true;
            }
        };
    }
}

