/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import com.github.goingoffskript.skriptvariabledump.SkriptToYaml;
import com.shanebeestudios.skbee.api.NBT.NBTApi;
import com.shanebeestudios.skbee.api.NBT.NBTContainer;
import com.shanebeestudios.skbee.api.NBT.utils.MinecraftVersion;
import com.shanebeestudios.skbee.api.listener.BoundBorderListener;
import com.shanebeestudios.skbee.api.listener.EntityListener;
import com.shanebeestudios.skbee.api.listener.NBTListener;
import com.shanebeestudios.skbee.api.structure.StructureBeeManager;
import com.shanebeestudios.skbee.api.structure.api.enumeration.Version;
import com.shanebeestudios.skbee.api.structure.bukkit.service.ProxyServiceImpl;
import com.shanebeestudios.skbee.api.util.LoggerBee;
import com.shanebeestudios.skbee.api.util.Util;
import com.shanebeestudios.skbee.api.virtualfurnace.api.VirtualFurnaceAPI;
import com.shanebeestudios.skbee.config.Config;
import com.shanebeestudios.skbee.elements.board.listener.PlayerBoardListener;
import com.shanebeestudios.skbee.elements.board.objects.Board;
import com.shanebeestudios.skbee.elements.bound.config.BoundConfig;
import com.shanebeestudios.skbee.elements.bound.objects.Bound;
import com.shanebeestudios.skbee.elements.virtualfurnace.listener.VirtualFurnaceListener;
import com.shanebeestudios.skbee.elements.worldcreator.objects.BeeWorldConfig;
import com.shanebeestudios.skbee.metrics.Metrics;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class SkBee
extends JavaPlugin {
    private static SkBee instance;
    private NBTApi nbtApi;
    private PluginManager pm;
    private Config config;
    private BoundConfig boundConfig = null;
    private SkriptAddon addon;
    private VirtualFurnaceAPI virtualFurnaceAPI;
    private BeeWorldConfig beeWorldConfig;
    private StructureBeeManager structureBeeManager = null;

    public void onEnable() {
        long start = System.currentTimeMillis();
        instance = this;
        this.config = new Config(this);
        this.nbtApi = new NBTApi();
        MinecraftVersion.replaceLogger(LoggerBee.getLogger());
        this.pm = Bukkit.getPluginManager();
        PluginDescriptionFile desc = this.getDescription();
        Plugin SKRIPT = this.pm.getPlugin("Skript");
        if (SKRIPT == null) {
            Util.log("&cDependency Skript was not found, plugin disabling.");
            this.pm.disablePlugin((Plugin)this);
            return;
        }
        if (!SKRIPT.isEnabled()) {
            Util.log("&cDependency Skript is not enabled, plugin disabling.");
            Util.log("&cThis could mean SkBee is being forced to load before Skript.");
            this.pm.disablePlugin((Plugin)this);
            return;
        }
        if (!Skript.isAcceptRegistrations()) {
            Util.log("&cSkript is no longer accepting registrations.");
            Util.log("&cNo clue how this could happen.");
            Util.log("&cSeems a plugin is delaying SkBee loading, which is after Skript stops accepting registrations.");
            this.pm.disablePlugin((Plugin)this);
            return;
        }
        if (!Skript.isRunningMinecraft((int)1, (int)14, (int)4)) {
            Util.log("&cYour server version &7'&b%s&7'&c is not supported, only MC 1.14.4+ is supported!", Skript.getMinecraftVersion());
            this.pm.disablePlugin((Plugin)this);
            return;
        }
        this.addon = Skript.registerAddon((JavaPlugin)this);
        this.addon.setLanguageFileDirectory("lang");
        this.loadNBTElements();
        this.loadRecipeElements();
        this.loadBoardElements();
        this.loadBoundElements();
        this.loadTextElements();
        this.loadPathElements();
        this.loadStructureElements();
        this.loadOtherElements();
        this.loadVirtualFurnaceElements();
        this.loadWorldCreatorElements();
        if (desc.getVersion().contains("Beta")) {
            Util.log("&eThis is a BETA build, things may not work as expected, please report any bugs on GitHub");
            Util.log("&ehttps://github.com/ShaneBeee/SkBee/issues");
        }
        this.loadMetrics();
        Util.log("&aSuccessfully enabled v%s&7 in &b%.2f seconds", desc.getVersion(), Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f));
        if (this.beeWorldConfig != null && this.config.AUTO_LOAD_WORLDS) {
            this.beeWorldConfig.loadCustomWorlds();
        }
    }

    private void loadNBTElements() {
        if (!this.config.ELEMENTS_NBT) {
            Util.log("&5NBT Elements &cdisabled via config");
            return;
        }
        try {
            this.nbtApi.forceLoadNBT();
        }
        catch (Exception ignore) {
            String ver = Skript.getMinecraftVersion().toString();
            Util.log("&5NBT Elements &cDISABLED!");
            Util.log(" - Your server version [&b" + ver + "&7] is not currently supported by the NBT-API");
            Util.log(" - This is not a bug!");
            Util.log(" - NBT elements will resume once the API is updated to work with [&b" + ver + "&7]");
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.nbt", new String[0]);
            Plugin plugin = Bukkit.getPluginManager().getPlugin("skript-variable-dump");
            if (plugin != null && Skript.classExists((String)"com.github.goingoffskript.skriptvariabledump.SkriptToYaml")) {
                SkriptToYaml.adapts(NBTContainer.class, (compound, map) -> map.put("nbt-compound", compound.toString()));
            }
            if (NBTApi.SUPPORTS_BLOCK_NBT) {
                this.pm.registerEvents((Listener)new NBTListener(this), (Plugin)this);
            }
            Util.log("&5NBT Elements &asuccessfully loaded");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.pm.disablePlugin((Plugin)this);
        }
    }

    private void loadRecipeElements() {
        if (!this.config.ELEMENTS_RECIPE) {
            Util.log("&5Recipe Elements &cdisabled via config");
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.recipe", new String[0]);
            Util.log("&5Recipe Elements &asuccessfully loaded");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.pm.disablePlugin((Plugin)this);
        }
    }

    private void loadBoardElements() {
        if (!this.config.ELEMENTS_BOARD) {
            Util.log("&5Scoreboard Elements &cdisabled via config");
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.board", new String[0]);
            this.pm.registerEvents((Listener)new PlayerBoardListener(), (Plugin)this);
            Bukkit.getOnlinePlayers().forEach(Board::createBoard);
            Util.log("&5Scoreboard Elements &asuccessfully loaded");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.pm.disablePlugin((Plugin)this);
        }
    }

    private void loadBoundElements() {
        if (!this.config.ELEMENTS_BOUND) {
            Util.log("&5Bound Elements &cdisabled via config");
            return;
        }
        try {
            this.boundConfig = new BoundConfig(this);
            this.pm.registerEvents((Listener)new BoundBorderListener(this), (Plugin)this);
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.bound", new String[0]);
            Util.log("&5Bound Elements &asuccessfully loaded");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.pm.disablePlugin((Plugin)this);
        }
    }

    private void loadTextElements() {
        if (!this.config.ELEMENTS_TEXT_COMPONENT) {
            Util.log("&5Text Component Elements &cdisabled via config");
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.text", new String[0]);
            Util.log("&5Text Component Elements &asuccessfully loaded");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.pm.disablePlugin((Plugin)this);
        }
    }

    private void loadPathElements() {
        if (!this.config.ELEMENTS_PATHFINDING) {
            Util.log("&5Pathfinding Elements &cdisabled via config");
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.path", new String[0]);
            Util.log("&5Pathfinding Elements &asuccessfully loaded");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.pm.disablePlugin((Plugin)this);
        }
    }

    private void loadStructureElements() {
        if (!this.config.ELEMENTS_STRUCTURE) {
            Util.log("&5Structure Elements &cdisabled via config");
            return;
        }
        if (Skript.classExists((String)"org.bukkit.structure.Structure")) {
            this.structureBeeManager = new StructureBeeManager();
            try {
                this.addon.loadClasses("com.shanebeestudios.skbee.elements.structure", new String[0]);
                Util.log("&5New Structure Elements &asuccessfully loaded");
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.pm.disablePlugin((Plugin)this);
            }
        }
        if (Skript.isRunningMinecraft((int)1, (int)18)) {
            Util.log("&5Old Structure Elements &cDISABLED!");
            Util.log(" - Old structure system is no longer available on MC 1.18+");
            Util.log(" - Please use new structure system");
            return;
        }
        ProxyServiceImpl impl = new ProxyServiceImpl((Plugin)this);
        Version serverVersion = impl.getServerVersion();
        if (serverVersion == null || serverVersion == Version.VERSION_UNKNOWN) {
            String ver = Skript.getMinecraftVersion().toString();
            Util.log("&5Structure Elements &cDISABLED!");
            Util.log(" - Your server version [&b" + ver + "&7] is not currently supported by the StructureBlock API");
            Util.log(" - This is not a bug!");
            Util.log(" - Structure elements will resume once the API is updated to work with [&b" + ver + "&7]");
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.structureold", new String[0]);
            Util.log("&5Old Structure Elements &asuccessfully loaded");
            Util.log(" - &cThe old system will be removed in the future");
            Util.log(" - &cPlease use the new structure system (Available on MC 1.17.1+)");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.pm.disablePlugin((Plugin)this);
        }
    }

    private void loadVirtualFurnaceElements() {
        if (Skript.classExists((String)"org.bukkit.persistence.PersistentDataContainer")) {
            if (!this.config.ELEMENTS_VIRTUAL_FURNACE) {
                Util.log("&5Virtual Furnace Elements &cdisabled via config");
                return;
            }
            try {
                this.virtualFurnaceAPI = new VirtualFurnaceAPI(this, true);
                this.pm.registerEvents((Listener)new VirtualFurnaceListener(), (Plugin)this);
                this.addon.loadClasses("com.shanebeestudios.skbee.elements.virtualfurnace", new String[0]);
                Util.log("&5Virtual Furnace Elements &asuccessfully loaded");
            }
            catch (IOException e) {
                e.printStackTrace();
                this.pm.disablePlugin((Plugin)this);
            }
        } else {
            Util.log("&5Virtual Furnace Elements &cdisabled");
            Util.log("&7 - Virtual Furnace elements are only available on 1.14+");
        }
    }

    private void loadOtherElements() {
        try {
            this.pm.registerEvents((Listener)new EntityListener(), (Plugin)this);
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.other", new String[0]);
            Util.log("&5Other Elements &asuccessfully loaded");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.pm.disablePlugin((Plugin)this);
        }
    }

    private void loadWorldCreatorElements() {
        if (!this.config.ELEMENTS_WORLD_CREATOR) {
            Util.log("&5World Creator Elements &cdisabled via config");
            return;
        }
        try {
            this.beeWorldConfig = new BeeWorldConfig(this);
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.worldcreator", new String[0]);
            Util.log("&5World Creator Elements &asuccessfully loaded");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.pm.disablePlugin((Plugin)this);
        }
    }

    private void loadMetrics() {
        Metrics metrics = new Metrics((Plugin)this, 6719);
        metrics.addCustomChart(new Metrics.SimplePie("skript_version", () -> Skript.getVersion().toString()));
    }

    public void onDisable() {
        if (this.virtualFurnaceAPI != null) {
            this.virtualFurnaceAPI.disableAPI();
        }
        Board.clearBoards();
    }

    public static SkBee getPlugin() {
        return instance;
    }

    public Config getPluginConfig() {
        return this.config;
    }

    public BoundConfig getBoundConfig() {
        return this.boundConfig;
    }

    public BeeWorldConfig getBeeWorldConfig() {
        return this.beeWorldConfig;
    }

    public NBTApi getNbtApi() {
        return this.nbtApi;
    }

    public VirtualFurnaceAPI getVirtualFurnaceAPI() {
        return this.virtualFurnaceAPI;
    }

    public StructureBeeManager getStructureBeeManager() {
        return this.structureBeeManager;
    }

    static {
        ConfigurationSerialization.registerClass(Bound.class, (String)"Bound");
    }
}

