/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.NBT;

import com.shanebeestudios.skbee.api.NBT.NBTBlock;
import com.shanebeestudios.skbee.api.NBT.NBTCompound;
import com.shanebeestudios.skbee.api.NBT.NBTContainer;
import org.bukkit.block.Block;

public class NBTCustomBlock
extends NBTBlock {
    private final Block block;

    public NBTCustomBlock(Block block) {
        super(block);
        this.block = block;
    }

    @Override
    public NBTCompound getData() {
        NBTCompound data = super.getData();
        if (!data.hasKey("custom").booleanValue()) {
            this.setData(data);
        } else if (!data.getString("id").equals(this.block.getType().getKey().toString())) {
            this.setData(data);
        } else if (data.getInteger("x").intValue() != this.block.getX()) {
            this.setData(data);
        } else if (data.getInteger("y").intValue() != this.block.getY()) {
            this.setData(data);
        } else if (data.getInteger("z").intValue() != this.block.getZ()) {
            this.setData(data);
        }
        return data;
    }

    private void setData(NBTCompound data) {
        data.getKeys().forEach(data::removeKey);
        data.setString("id", this.block.getType().getKey().toString());
        data.setInteger("x", this.block.getX());
        data.setInteger("y", this.block.getY());
        data.setInteger("z", this.block.getZ());
        data.getOrCreateCompound("custom");
    }

    public NBTCompound getCustomData() {
        return this.getData().getOrCreateCompound("custom");
    }

    public NBTCompound cloneCustomData() {
        return new NBTContainer(this.getCustomData().toString());
    }
}

