/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.NBT;

import com.shanebeestudios.skbee.api.NBT.NBTApi;
import com.shanebeestudios.skbee.api.NBT.NBTCompound;
import com.shanebeestudios.skbee.api.NBT.NBTContainer;
import com.shanebeestudios.skbee.api.NBT.NBTCustom;
import com.shanebeestudios.skbee.api.NBT.NBTEntity;
import com.shanebeestudios.skbee.api.NBT.NbtApiException;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class NBTCustomEntity
extends NBTEntity
implements NBTCustom {
    private final Entity entity;
    private final String KEY = "skbee-custom";

    public NBTCustomEntity(Entity entity) {
        super(entity);
        this.entity = entity;
        if (NBTApi.HAS_PERSISTENCE) {
            this.convert();
        }
    }

    @Override
    public NBTCompound getCustomNBT() {
        return this.getPersistentDataContainer().getOrCreateCompound("skbee-custom");
    }

    @Override
    public void deleteCustomNBT() {
        this.getPersistentDataContainer().removeKey("skbee-custom");
    }

    private NBTCompound getCustomNBTCompound() {
        String bukkit = "BukkitValues";
        NBTContainer compound = new NBTContainer(new NBTEntity(this.entity).toString());
        NBTCompound custom = null;
        if (compound.hasKey(bukkit).booleanValue()) {
            NBTCompound persist = compound.getCompound(bukkit);
            persist.removeKey("__nbtapi");
            if (persist.hasKey("skbee-custom").booleanValue()) {
                custom = this.getPersistentDataContainer().getCompound("skbee-custom");
                persist.removeKey("skbee-custom");
            }
            if (persist.getKeys().size() == 0) {
                compound.removeKey(bukkit);
            }
        }
        NBTCompound customCompound = compound.getOrCreateCompound("custom");
        if (custom != null) {
            customCompound.mergeCompound(custom);
        }
        return compound;
    }

    @Override
    public NBTCompound getOrCreateCompound(String name) {
        if (name.equals("custom")) {
            return this.getPersistentDataContainer().getOrCreateCompound("skbee-custom");
        }
        return super.getOrCreateCompound(name);
    }

    @Override
    public Boolean hasKey(String key) {
        if (key.equalsIgnoreCase("custom")) {
            return true;
        }
        return super.hasKey(key);
    }

    @Override
    public String toString() {
        try {
            if (NBTApi.HAS_PERSISTENCE) {
                return this.getCustomNBTCompound().toString();
            }
            return super.toString();
        }
        catch (NbtApiException ignore) {
            return null;
        }
    }

    private void convert() {
        PersistentDataContainer container = this.entity.getPersistentDataContainer();
        if (container.has(OLD_KEY, PersistentDataType.STRING)) {
            String data = (String)container.get(OLD_KEY, PersistentDataType.STRING);
            NBTCompound custom = this.getOrCreateCompound("custom");
            if (data != null) {
                custom.mergeCompound(new NBTContainer(data));
            }
            container.remove(OLD_KEY);
        }
    }
}

