/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.NBT;

import com.shanebeestudios.skbee.api.NBT.NBTApi;
import com.shanebeestudios.skbee.api.NBT.NBTCompound;
import com.shanebeestudios.skbee.api.NBT.NBTContainer;
import com.shanebeestudios.skbee.api.NBT.NBTCustom;
import com.shanebeestudios.skbee.api.NBT.NBTTileEntity;
import com.shanebeestudios.skbee.api.NBT.NbtApiException;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class NBTCustomTileEntity
extends NBTTileEntity
implements NBTCustom {
    private final BlockState blockState;
    private final String KEY = "skbee-custom";

    public NBTCustomTileEntity(BlockState tile) {
        super(tile);
        this.blockState = tile;
        if (NBTApi.HAS_PERSISTENCE) {
            this.convert();
        }
    }

    @Override
    public NBTCompound getCustomNBT() {
        return this.getPersistentDataContainer().getOrCreateCompound("skbee-custom");
    }

    @Override
    public void deleteCustomNBT() {
        this.getPersistentDataContainer().removeKey("skbee-custom");
    }

    private NBTCompound getCustomNBTCompound() {
        String bukkit = "PublicBukkitValues";
        NBTContainer compound = new NBTContainer(new NBTTileEntity(this.blockState).toString());
        NBTCompound custom = null;
        if (compound.hasKey(bukkit).booleanValue()) {
            NBTCompound persist = compound.getCompound(bukkit);
            persist.removeKey("__nbtapi");
            if (persist.hasKey("skbee-custom").booleanValue()) {
                custom = this.getPersistentDataContainer().getCompound("skbee-custom");
                persist.removeKey("skbee-custom");
            }
            if (persist.getKeys().size() == 0) {
                compound.removeKey(bukkit);
            }
        }
        NBTCompound customCompound = compound.getOrCreateCompound("custom");
        if (custom != null) {
            customCompound.mergeCompound(custom);
        }
        return compound;
    }

    @Override
    public NBTCompound getOrCreateCompound(String name) {
        if (name.equals("custom")) {
            return this.getPersistentDataContainer().getOrCreateCompound("skbee-custom");
        }
        return super.getOrCreateCompound(name);
    }

    @Override
    public Boolean hasKey(String key) {
        if (key.equalsIgnoreCase("custom")) {
            return true;
        }
        return super.hasKey(key);
    }

    @Override
    public String toString() {
        try {
            if (NBTApi.HAS_PERSISTENCE) {
                return this.getCustomNBTCompound().toString();
            }
            return super.toString();
        }
        catch (NbtApiException ignore) {
            return null;
        }
    }

    private void convert() {
        PersistentDataContainer container = ((TileState)this.blockState).getPersistentDataContainer();
        if (container.has(OLD_KEY, PersistentDataType.STRING)) {
            String data = (String)container.get(OLD_KEY, PersistentDataType.STRING);
            container.remove(OLD_KEY);
            if (data != null) {
                this.blockState.update();
                NBTCompound custom = this.getOrCreateCompound("custom");
                custom.mergeCompound(new NBTContainer(data));
            }
        }
    }
}

