/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.NBT;

import ch.njol.util.StringUtils;
import com.shanebeestudios.skbee.api.NBT.NBTCompound;
import com.shanebeestudios.skbee.api.NBT.NBTType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public enum NBTCustomType {
    NBTTagEnd("tag end", NBTType.NBTTagEnd),
    NBTTagByte("byte", NBTType.NBTTagByte),
    NBTTagShort("short", NBTType.NBTTagShort),
    NBTTagInt("int", NBTType.NBTTagInt),
    NBTTagLong("long", NBTType.NBTTagLong),
    NBTTagFloat("float", NBTType.NBTTagFloat),
    NBTTagDouble("double", NBTType.NBTTagDouble),
    NBTTagByteArray("byte array", NBTType.NBTTagByteArray),
    NBTTagIntArray("int array", NBTType.NBTTagIntArray),
    NBTTagString("string", NBTType.NBTTagString),
    NBTTagCompound("compound", NBTType.NBTTagCompound),
    NBTTagDoubleList("double list", NBTType.NBTTagList),
    NBTTagFloatList("float list", NBTType.NBTTagList),
    NBTTagLongList("long list", NBTType.NBTTagList),
    NBTTagIntList("int list", NBTType.NBTTagList),
    NBTTagCompoundList("compound list", NBTType.NBTTagList),
    NBTTagStringList("string list", NBTType.NBTTagList);

    String name;
    NBTType nbtType;
    private static final Map<String, NBTCustomType> BY_NAME;
    private static final Map<NBTType, NBTCustomType> BY_TYPE;

    private NBTCustomType(String name, NBTType nbtType) {
        this.name = name + " tag";
        this.nbtType = nbtType;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public static NBTCustomType fromName(String name) {
        String s = name.toLowerCase(Locale.ROOT);
        if (BY_NAME.containsKey(s)) {
            return BY_NAME.get(s);
        }
        return null;
    }

    @Nullable
    public static NBTCustomType getByTag(NBTCompound compound, String key) {
        NBTType nbtType = compound.getType(key);
        if (BY_TYPE.containsKey((Object)nbtType)) {
            if (nbtType == NBTType.NBTTagList) {
                if (compound.getIntegerList(key).size() > 0) {
                    return NBTTagIntList;
                }
                if (compound.getLongList(key).size() > 0) {
                    return NBTTagLongList;
                }
                if (compound.getFloatList(key).size() > 0) {
                    return NBTTagFloatList;
                }
                if (compound.getDoubleList(key).size() > 0) {
                    return NBTTagDoubleList;
                }
                if (compound.getCompoundList(key).size() > 0) {
                    return NBTTagCompoundList;
                }
                if (compound.getStringList(key).size() > 0) {
                    return NBTTagStringList;
                }
            }
            return BY_TYPE.get((Object)nbtType);
        }
        return null;
    }

    public static String getNames() {
        ArrayList<String> names = new ArrayList<String>(BY_NAME.keySet());
        Collections.sort(names);
        return StringUtils.join(names, (String)", ");
    }

    static {
        BY_NAME = new HashMap<String, NBTCustomType>();
        BY_TYPE = new HashMap<NBTType, NBTCustomType>();
        for (NBTCustomType type : NBTCustomType.values()) {
            if (type != NBTTagEnd) {
                BY_NAME.put(type.name, type);
            }
            BY_TYPE.put(type.nbtType, type);
        }
    }
}

