/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.NBT;

import com.shanebeestudios.skbee.api.NBT.NBTCompound;
import com.shanebeestudios.skbee.api.NBT.NBTPersistentDataContainer;
import com.shanebeestudios.skbee.api.NBT.NBTReflectionUtil;
import com.shanebeestudios.skbee.api.NBT.utils.MinecraftVersion;
import com.shanebeestudios.skbee.api.NBT.utils.annotations.AvailableSince;
import com.shanebeestudios.skbee.api.NBT.utils.annotations.CheckUtil;
import com.shanebeestudios.skbee.api.NBT.utils.annotations.FAUtil;
import org.bukkit.entity.Entity;

public class NBTEntity
extends NBTCompound {
    private final Entity ent;

    public NBTEntity(Entity entity) {
        super(null, null);
        if (entity == null) {
            throw new NullPointerException("Entity can't be null!");
        }
        this.ent = entity;
    }

    @Override
    public Object getCompound() {
        return NBTReflectionUtil.getEntityNBTTagCompound(NBTReflectionUtil.getNMSEntity(this.ent));
    }

    @Override
    protected void setCompound(Object compound) {
        NBTReflectionUtil.setEntityNBTTag(compound, NBTReflectionUtil.getNMSEntity(this.ent));
    }

    @AvailableSince(version=MinecraftVersion.MC1_14_R1)
    public NBTCompound getPersistentDataContainer() {
        FAUtil.check(this::getPersistentDataContainer, CheckUtil::isAvaliable);
        return new NBTPersistentDataContainer(this.ent.getPersistentDataContainer());
    }
}

