/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.listener;

import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.NBT.NBTApi;
import com.shanebeestudios.skbee.api.NBT.NBTChunk;
import com.shanebeestudios.skbee.api.NBT.NBTCompound;
import com.shanebeestudios.skbee.api.NBT.NBTCustomBlock;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.plugin.Plugin;

public class NBTListener
implements Listener {
    private final SkBee plugin;

    public NBTListener(SkBee plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.breakBlock(event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onEntityBreakBlock(EntityChangeBlockEvent event) {
        if (event.isCancelled()) {
            return;
        }
        switch (event.getEntity().getType()) {
            case ENDERMAN: 
            case ZOMBIE: 
            case SILVERFISH: 
            case RABBIT: 
            case RAVAGER: 
            case WITHER: {
                this.breakBlock(event.getBlock());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onExplode(BlockExplodeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        event.blockList().forEach(this::breakBlock);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onEntityExplode(EntityExplodeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        event.blockList().forEach(this::breakBlock);
    }

    private void breakBlock(Block block) {
        String blockKey;
        NBTCompound blocksContainer;
        BlockState blockState = block.getState();
        if (NBTApi.isTileEntity(blockState)) {
            return;
        }
        if (!NBTApi.SUPPORTS_BLOCK_NBT) {
            return;
        }
        NBTCompound chunkContainer = new NBTChunk(block.getChunk()).getPersistentDataContainer();
        if (chunkContainer.hasKey("blocks").booleanValue() && (blocksContainer = chunkContainer.getCompound("blocks")).hasKey(blockKey = this.getKey(block)).booleanValue()) {
            blocksContainer.removeKey(blockKey);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onPistonPush(BlockPistonExtendEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block piston = event.getBlock();
        BlockState blockState = piston.getState();
        if (event.isSticky()) {
            return;
        }
        if (NBTApi.isTileEntity(blockState)) {
            return;
        }
        if (!NBTApi.SUPPORTS_BLOCK_NBT) {
            return;
        }
        event.getBlocks().forEach(block -> {
            NBTCompound blocksContainer;
            NBTCompound chunkContainer = new NBTChunk(block.getChunk()).getPersistentDataContainer();
            if (chunkContainer.hasKey("blocks").booleanValue() && (blocksContainer = chunkContainer.getCompound("blocks")).hasKey(this.getKey((Block)block)).booleanValue()) {
                this.shiftBlock((Block)block, blocksContainer, event.getDirection());
            }
        });
    }

    private void shiftBlock(Block block, NBTCompound compound, BlockFace direction) {
        BlockData oldBlockData = block.getBlockData();
        Block newBlock = block.getRelative(direction, 1);
        NBTCompound oldData = new NBTCustomBlock(block).cloneCustomData();
        compound.removeKey(this.getKey(block));
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (newBlock.getBlockData().matches(oldBlockData)) {
                new NBTCustomBlock(newBlock).getCustomData().mergeCompound(oldData);
            }
        }, 5L);
    }

    private String getKey(Block block) {
        return String.format("%s_%s_%s", block.getX(), block.getY(), block.getZ());
    }
}

