/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.reflection;

import ch.njol.skript.Skript;
import com.shanebeestudios.skbee.api.NBT.NBTCompound;
import com.shanebeestudios.skbee.api.NBT.NBTContainer;
import com.shanebeestudios.skbee.api.reflection.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.scoreboard.Team;

public class ChatReflection {
    private static final boolean NEW_PRETTY_NBT = Skript.isRunningMinecraft((int)1, (int)17);
    private static final Class<?> ICHAT_BASE_COMPONENT_CLASS = ReflectionUtils.getNMSClass("IChatBaseComponent", "net.minecraft.network.chat");
    private static final Class<?> CRAFT_CHAT_MESSAGE_CLASS = ReflectionUtils.getOBCClass("util.CraftChatMessage");
    private static final Class<?> TEXT_TAG_VISITOR_CLASS;
    private static final Class<?> NBT_BASE_CLASS;
    private static final Method FROM_COMPONENT;
    private static final Method VISIT_METHOD;
    private static final Class<?> CRAFT_CHAT_MESSAGE;
    private static final Class<?> CRAFT_TEAM;
    private static final Class<?> NMS_TEAM;
    private static final Method SET_PREFIX;
    private static final Method PREFIX_COMP_METHOD;

    public static String getPrettyNBT(NBTCompound compound, String split) {
        if (NEW_PRETTY_NBT) {
            return ChatReflection.getPretty_17(compound, split);
        }
        return ChatReflection.getPretty_16(compound, split);
    }

    private static String getPretty_16(NBTCompound compound, String split) {
        Object nmsNBT = new NBTContainer(compound.toString()).getCompound();
        String s = split != null ? split : "";
        try {
            Method prettyMethod = nmsNBT.getClass().getMethod("a", String.class, Integer.TYPE);
            Object prettyComponent = prettyMethod.invoke(nmsNBT, s, 0);
            assert (CRAFT_CHAT_MESSAGE_CLASS != null);
            return (String)FROM_COMPONENT.invoke(CRAFT_CHAT_MESSAGE_CLASS, prettyComponent);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getPretty_17(NBTCompound compound, String split) {
        Object nmsNBT = new NBTContainer(compound.toString()).getCompound();
        String s = split != null ? split : "";
        try {
            Object tagVisitorInstance = TEXT_TAG_VISITOR_CLASS.getConstructor(String.class, Integer.TYPE).newInstance(s, 0);
            Object prettyComponent = VISIT_METHOD.invoke(tagVisitorInstance, nmsNBT);
            return (String)FROM_COMPONENT.invoke(CRAFT_CHAT_MESSAGE_CLASS, prettyComponent);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setTeamPrefix(Team team, String prefix) {
        if (CRAFT_TEAM == null || PREFIX_COMP_METHOD == null || SET_PREFIX == null) {
            team.setPrefix("");
            team.setSuffix("");
            return;
        }
        try {
            Object nmsTeam = ReflectionUtils.getField("team", CRAFT_TEAM, team);
            Object prefixComp = PREFIX_COMP_METHOD.invoke(null, prefix);
            SET_PREFIX.invoke(nmsTeam, prefixComp);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    static {
        NBT_BASE_CLASS = ReflectionUtils.getNMSClass("NBTBase", "net.minecraft.nbt");
        TEXT_TAG_VISITOR_CLASS = NEW_PRETTY_NBT ? ReflectionUtils.getNMSClass("TextComponentTagVisitor", "net.minecraft.nbt") : null;
        Method from_comp = null;
        Method visit = null;
        try {
            if (NEW_PRETTY_NBT) {
                assert (TEXT_TAG_VISITOR_CLASS != null);
                visit = TEXT_TAG_VISITOR_CLASS.getDeclaredMethod("a", NBT_BASE_CLASS);
            }
            assert (CRAFT_CHAT_MESSAGE_CLASS != null);
            from_comp = CRAFT_CHAT_MESSAGE_CLASS.getMethod("fromComponent", ICHAT_BASE_COMPONENT_CLASS);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        FROM_COMPONENT = from_comp;
        VISIT_METHOD = visit;
        CRAFT_CHAT_MESSAGE = ReflectionUtils.getOBCClass("util.CraftChatMessage");
        CRAFT_TEAM = ReflectionUtils.getOBCClass("scoreboard.CraftTeam");
        NMS_TEAM = ReflectionUtils.getNMSClass("ScoreboardTeam", "net.minecraft.world.scores");
        Method PREFIX_COMP_METHOD1 = null;
        Method SET_PREFIX1 = null;
        if (CRAFT_TEAM != null && NMS_TEAM != null && CRAFT_CHAT_MESSAGE != null) {
            try {
                SET_PREFIX1 = NMS_TEAM.getDeclaredMethod("setPrefix", ICHAT_BASE_COMPONENT_CLASS);
                PREFIX_COMP_METHOD1 = CRAFT_CHAT_MESSAGE.getDeclaredMethod("fromStringOrNull", String.class);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        PREFIX_COMP_METHOD = PREFIX_COMP_METHOD1;
        SET_PREFIX = SET_PREFIX1;
    }
}

