/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.structure;

import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.util.Util;
import java.io.IOException;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.structure.Structure;
import org.bukkit.structure.StructureManager;
import org.bukkit.util.BlockVector;

public class StructureBee {
    private static final StructureManager STRUCTURE_MANAGER = Bukkit.getStructureManager();
    private final Structure structure;
    private final NamespacedKey key;
    private StructureRotation rotation = StructureRotation.NONE;
    private Mirror mirror = Mirror.NONE;
    private float integrity = 1.0f;
    private boolean includeEntities = true;

    public StructureBee(Structure structure, NamespacedKey key) {
        this.key = key;
        this.structure = structure;
    }

    public void fill(Location location, BlockVector blockVector) {
        this.structure.fill(location, blockVector, true);
    }

    public void place(Location location) {
        this.structure.place(location, this.includeEntities, this.rotation, this.mirror, -1, this.integrity, new Random());
    }

    public void save() {
        block2: {
            try {
                STRUCTURE_MANAGER.saveStructure(this.key, this.structure);
            }
            catch (IOException e) {
                Util.skriptError("Could not save structure '%s', enable debug in SkBee config for more info.", this.getName());
                if (!SkBee.getPlugin().getPluginConfig().SETTINGS_DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public Structure getBukkitStructure() {
        return this.structure;
    }

    public String getName() {
        return this.key.getKey();
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public StructureRotation getRotation() {
        return this.rotation;
    }

    public void setRotation(StructureRotation rotation) {
        this.rotation = rotation;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public void setMirror(Mirror mirror) {
        this.mirror = mirror;
    }

    public float getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(float integrity) {
        this.integrity = integrity;
    }

    public boolean isIncludeEntities() {
        return this.includeEntities;
    }

    public void setIncludeEntities(boolean includeEntities) {
        this.includeEntities = includeEntities;
    }

    public BlockVector getSize() {
        return this.structure.getSize();
    }

    public String toString() {
        return String.format("Structure{key=\"%s\", rotation=%s, mirror=%s, integrity=%s, includeEntities=%s (%s), size=[%s]}", this.key, this.rotation, this.mirror, Float.valueOf(this.integrity), this.includeEntities, this.structure.getEntityCount(), this.structure.getSize());
    }
}

