/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.structure;

import com.shanebeestudios.skbee.api.structure.StructureBee;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.structure.Structure;
import org.bukkit.structure.StructureManager;
import org.jetbrains.annotations.NotNull;

public class StructureBeeManager {
    private final Map<String, StructureBee> STRUCTURE_MAP = new HashMap<String, StructureBee>();
    private final StructureManager STRUCTURE_MANAGER = Bukkit.getStructureManager();

    @NotNull
    public StructureBee getStructure(String name) {
        if (this.STRUCTURE_MAP.containsKey(name)) {
            return this.STRUCTURE_MAP.get(name);
        }
        NamespacedKey namespacedKey = name.contains(":") ? NamespacedKey.fromString((String)name) : NamespacedKey.minecraft((String)name);
        Structure structure = this.STRUCTURE_MANAGER.loadStructure(namespacedKey, true);
        if (structure == null) {
            structure = this.STRUCTURE_MANAGER.createStructure();
            this.STRUCTURE_MANAGER.registerStructure(namespacedKey, structure);
        }
        StructureBee structureBee = new StructureBee(structure, namespacedKey);
        this.STRUCTURE_MAP.put(name, structureBee);
        return structureBee;
    }
}

