/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.structure.bukkit.service;

import com.shanebeestudios.skbee.api.structure.api.entity.Position;
import com.shanebeestudios.skbee.api.structure.api.enumeration.Version;
import com.shanebeestudios.skbee.api.structure.api.service.ProxyService;
import com.shanebeestudios.skbee.api.structure.core.entity.PositionImpl;
import com.shanebeestudios.skbee.api.structure.lib.org.jetbrains.annotations.NotNull;
import com.shanebeestudios.skbee.api.structure.lib.org.jetbrains.annotations.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ProxyServiceImpl
implements ProxyService {
    private Plugin plugin;

    public ProxyServiceImpl(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    @Nullable
    public <L> L toLocation(@Nullable Position position) {
        if (position == null) {
            return null;
        }
        return (L)new Location(Bukkit.getWorld((String)position.getWorldName()), position.getX(), position.getY(), position.getZ());
    }

    @Override
    @Nullable
    public <V> V toVector(@Nullable Position position) {
        if (position == null) {
            return null;
        }
        return (V)new Vector(position.getX(), position.getY(), position.getZ());
    }

    @Override
    @Nullable
    public <L> Position toPosition(@Nullable L location) {
        Location l;
        if (location == null) {
            return null;
        }
        PositionImpl position = new PositionImpl();
        if (location instanceof Location) {
            l = (Location)location;
            position.setWorldName(l.getWorld().getName());
            position.setX(l.getBlockX());
            position.setY(l.getBlockY());
            position.setZ(l.getBlockZ());
        }
        if (location instanceof Vector) {
            l = (Vector)location;
            position.setX(l.getBlockX());
            position.setY(l.getBlockY());
            position.setZ(l.getBlockZ());
        }
        return position;
    }

    @Override
    public void runAsyncTask(@NotNull Runnable runnable) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously(this.plugin, runnable);
    }

    @Override
    public void runSyncTask(@NotNull Runnable runnable) {
        this.plugin.getServer().getScheduler().runTask(this.plugin, runnable);
    }

    @Override
    public Version getServerVersion() {
        try {
            if (Bukkit.getServer() == null || Bukkit.getServer().getClass().getPackage() == null) {
                return Version.VERSION_UNKNOWN;
            }
            String version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
            for (Version versionSupport : Version.values()) {
                if (!versionSupport.getBukkitId().equals(version)) continue;
                return versionSupport;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Version.VERSION_UNKNOWN;
    }
}

