/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.structure.bukkit.v1_17_R1;

import com.shanebeestudios.skbee.api.structure.api.bukkit.block.StructureBlockData;
import com.shanebeestudios.skbee.api.structure.api.bukkit.block.StructureBlockLoad;
import com.shanebeestudios.skbee.api.structure.api.bukkit.block.StructureBlockSave;
import com.shanebeestudios.skbee.api.structure.api.entity.StructureLoaderAbstract;
import com.shanebeestudios.skbee.api.structure.api.entity.StructureSaverAbstract;
import com.shanebeestudios.skbee.api.structure.api.enumeration.StructureMirror;
import com.shanebeestudios.skbee.api.structure.api.enumeration.StructureMode;
import com.shanebeestudios.skbee.api.structure.api.enumeration.StructureRotation;
import com.shanebeestudios.skbee.api.structure.api.service.TypeConversionService;
import com.shanebeestudios.skbee.api.structure.core.block.StructureBlockAbstractImpl;
import com.shanebeestudios.skbee.api.structure.lib.org.jetbrains.annotations.NotNull;
import com.shanebeestudios.skbee.api.structure.lib.org.jetbrains.annotations.Nullable;
import java.lang.reflect.Method;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.block.CraftBlockState;
import org.bukkit.util.Vector;

public class CraftStructureBlock
extends CraftBlockState
implements StructureBlockData,
StructureBlockSave,
StructureBlockLoad {
    public StructureBlockAbstractImpl<Location, Vector> internalBlock;
    public TypeConversionService conversionService;
    public TileEntityStructure tileEntityStructure;

    public CraftStructureBlock(StructureBlockAbstractImpl<Location, Vector> structure, TypeConversionService conversionService, Block block) {
        super(block);
        CraftWorld world = (CraftWorld)block.getWorld();
        this.internalBlock = structure;
        this.conversionService = conversionService;
        this.tileEntityStructure = (TileEntityStructure)world.getHandle().getTileEntity(new BlockPosition(this.getX(), this.getY(), this.getZ()), true);
        if (this.tileEntityStructure == null) {
            throw new IllegalArgumentException("The block at " + world.getName() + " " + this.getX() + " " + this.getY() + " " + this.getZ() + " is not a StructureBlock.");
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound = this.saveCompoundTileEntityStructure(this.tileEntityStructure, compound);
        this.setSaveName(compound.getString("name"));
        this.setAuthor(compound.getString("author"));
        this.setBlockNameMetaData(compound.getString("metadata"));
        this.setStructureLocation(new Location(block.getWorld(), (double)compound.getInt("posX"), (double)compound.getInt("posY"), (double)compound.getInt("posZ")));
        this.setSizeX(compound.getInt("sizeX"));
        this.setSizeY(compound.getInt("sizeY"));
        this.setSizeZ(compound.getInt("sizeZ"));
        this.setIncludeEntities(!compound.getBoolean("ignoreEntities"));
        this.setBoundingBoxVisible(compound.getBoolean("showboundingbox"));
        this.setInvisibleBlocksEnabled(compound.getBoolean("showair"));
        this.setIntegrity(compound.getFloat("integrity"));
        this.setSeed(compound.getLong("seed"));
        this.setMirrorType(conversionService.convertToStructureMirror(EnumBlockMirror.valueOf((String)compound.getString("mirror"))));
        this.setRotationType(conversionService.convertToStructureRotation(EnumBlockRotation.valueOf((String)compound.getString("rotation"))));
        this.setStructureMode(conversionService.convertToStructureMode(BlockPropertyStructureMode.valueOf((String)compound.getString("mode"))));
    }

    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        NBTTagCompound compound = new NBTTagCompound();
        compound = this.saveCompoundTileEntityStructure(this.tileEntityStructure, compound);
        compound.setString("name", this.getSaveName());
        compound.setString("author", this.getAuthor());
        compound.setString("metadata", this.getBlockNameMetaData());
        compound.setInt("posX", this.getStructureLocation().getBlockX());
        compound.setInt("posY", this.getStructureLocation().getBlockY());
        compound.setInt("posZ", this.getStructureLocation().getBlockZ());
        compound.setInt("sizeX", this.getSizeX());
        compound.setInt("sizeY", this.getSizeY());
        compound.setInt("sizeZ", this.getSizeZ());
        compound.setBoolean("showboundingbox", this.isBoundingBoxVisible());
        compound.setBoolean("showair", this.isInvisibleBlocksEnabled());
        compound.setBoolean("ignoreEntities", !this.isIncludeEntitiesEnabled());
        compound.setFloat("integrity", this.getIntegrity());
        compound.setLong("seed", this.getSeed());
        compound.setString("rotation", this.conversionService.convertToRotationHandle(this.getRotationType()).toString());
        compound.setString("mirror", this.conversionService.convertToMirrorHandle(this.getMirrorType()).toString());
        compound.setString("mode", this.conversionService.convertToStructureModeHandle(this.getStructureMode()).toString());
        this.loadCompoundTileEntityStructure(this.tileEntityStructure, compound);
        this.setChangedTileEntityStructure(this.tileEntityStructure);
        return result;
    }

    @Override
    public void setMirrorType(@NotNull StructureMirror mirrorType) {
        this.internalBlock.setMirrorType(mirrorType);
    }

    @Override
    public void setRotationType(@NotNull StructureRotation rotation) {
        this.internalBlock.setRotationType(rotation);
    }

    @Override
    @NotNull
    public StructureRotation getRotationType() {
        return this.internalBlock.getRotationType();
    }

    @Override
    @NotNull
    public StructureMirror getMirrorType() {
        return this.internalBlock.getMirrorType();
    }

    @Override
    public void setBoundingBoxVisible(boolean visible) {
        this.internalBlock.setBoundingBoxVisible(visible);
    }

    @Override
    public boolean isBoundingBoxVisible() {
        return this.internalBlock.isBoundingBoxVisible();
    }

    @Override
    public void setIntegrity(float integrity) {
        this.internalBlock.setIntegrity(integrity);
    }

    @Override
    public float getIntegrity() {
        return this.internalBlock.getIntegrity();
    }

    @Override
    public void setSeed(long seed) {
        this.internalBlock.setSeed(seed);
    }

    @Override
    public long getSeed() {
        return this.internalBlock.getSeed();
    }

    @Override
    public void setAuthor(@Nullable String author) {
        this.internalBlock.setAuthor(author);
    }

    @Override
    @Nullable
    public String getAuthor() {
        return this.internalBlock.getAuthor();
    }

    @Override
    public void setStructureLocation(@Nullable Location location) {
        this.internalBlock.setStructureLocation(location);
    }

    @Override
    @Nullable
    public Location getStructureLocation() {
        return this.internalBlock.getStructureLocation();
    }

    @Override
    public void setIncludeEntities(boolean flag) {
        this.internalBlock.setIncludeEntities(flag);
    }

    @Override
    public boolean isIncludeEntitiesEnabled() {
        return this.internalBlock.isIncludeEntitiesEnabled();
    }

    @Override
    public void setSizeX(int sizeX) {
        this.internalBlock.setSizeX(sizeX);
    }

    @Override
    public void setSizeY(int sizeY) {
        this.internalBlock.setSizeY(sizeY);
    }

    @Override
    public void setSizeZ(int sizeZ) {
        this.internalBlock.setSizeZ(sizeZ);
    }

    @Override
    public int getSizeX() {
        return this.internalBlock.getSizeX();
    }

    @Override
    public int getSizeY() {
        return this.internalBlock.getSizeY();
    }

    @Override
    public int getSizeZ() {
        return this.internalBlock.getSizeZ();
    }

    @Override
    public void setSaveName(@Nullable String name) {
        this.internalBlock.setSaveName(name);
    }

    @Override
    @Nullable
    public String getSaveName() {
        return this.internalBlock.getSaveName();
    }

    @Override
    public void setBlockNameMetaData(@Nullable String blockNameMetaData) {
        this.internalBlock.setBlockNameMetaData(blockNameMetaData);
    }

    @Override
    @Nullable
    public String getBlockNameMetaData() {
        return this.internalBlock.getBlockNameMetaData();
    }

    @Override
    public void setInvisibleBlocksEnabled(boolean flag) {
        this.internalBlock.setInvisibleBlocksEnabled(flag);
    }

    @Override
    public boolean isInvisibleBlocksEnabled() {
        return this.internalBlock.isInvisibleBlocksEnabled();
    }

    @Override
    public void setStructureMode(@NotNull StructureMode structureMode) {
        this.internalBlock.setStructureMode(structureMode);
    }

    @Override
    @NotNull
    public StructureMode getStructureMode() {
        return this.internalBlock.getStructureMode();
    }

    @Override
    @NotNull
    public StructureLoaderAbstract<Location, Vector> loadStructure() {
        return this.internalBlock.loadStructure();
    }

    @Override
    @NotNull
    public StructureSaverAbstract<Location, Vector> saveStructure() {
        return this.internalBlock.saveStructure();
    }

    private NBTTagCompound saveCompoundTileEntityStructure(TileEntityStructure tileEntityStructure, NBTTagCompound compoundTag) {
        try {
            Method method = TileEntityStructure.class.getDeclaredMethod("save", NBTTagCompound.class);
            return (NBTTagCompound)method.invoke((Object)tileEntityStructure, compoundTag);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void loadCompoundTileEntityStructure(TileEntityStructure tileEntityStructure, NBTTagCompound compoundTag) {
        try {
            Method method = TileEntityStructure.class.getDeclaredMethod("load", NBTTagCompound.class);
            method.invoke((Object)tileEntityStructure, compoundTag);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setChangedTileEntityStructure(TileEntityStructure tileEntityStructure) {
        try {
            Method method = TileEntity.class.getDeclaredMethod("update", new Class[0]);
            method.invoke((Object)tileEntityStructure, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

