/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.structure.bukkit.v1_17_R1;

import com.shanebeestudios.skbee.api.structure.api.entity.StructurePlaceMeta;
import com.shanebeestudios.skbee.api.structure.api.entity.StructureReadMeta;
import com.shanebeestudios.skbee.api.structure.api.service.StructureWorldService;
import com.shanebeestudios.skbee.api.structure.api.service.TypeConversionService;
import java.util.Random;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRotation;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;

public class StructureWorldServiceImpl
implements StructureWorldService {
    private final TypeConversionService conversionService;

    public StructureWorldServiceImpl(TypeConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public void placeStructureToWorld(StructurePlaceMeta meta, Object structure) throws Exception {
        if (!(structure instanceof DefinedStructure)) {
            throw new IllegalArgumentException("StructureTemplate has to be an NMS handle!");
        }
        DefinedStructure template = (DefinedStructure)structure;
        WorldServer world = ((CraftWorld)Bukkit.getWorld((String)meta.getLocation().getWorldName())).getHandle();
        BlockPosition cornerBlock = new BlockPosition((int)meta.getLocation().getX(), (int)meta.getLocation().getY(), (int)meta.getLocation().getZ());
        DefinedStructureInfo info = new DefinedStructureInfo();
        info.a(!meta.isIncludeEntitiesEnabled());
        info.a((EnumBlockMirror)this.conversionService.convertToMirrorHandle(meta.getMirrorType()));
        info.a((EnumBlockRotation)this.conversionService.convertToRotationHandle(meta.getRotationType()));
        if (meta.getIntegrity() < 1.0f) {
            info.b();
            float rotation = MathHelper.a((float)meta.getIntegrity(), (float)0.0f, (float)1.0f);
            DefinedStructureProcessorRotation rotationProcessor = new DefinedStructureProcessorRotation(rotation);
            Random random = new Random();
            if (meta.getSeed() != 0L) {
                random = new Random(meta.getSeed());
            }
            info.a((DefinedStructureProcessor)rotationProcessor);
            info.a(random);
        }
        template.a((WorldAccess)world, cornerBlock, cornerBlock, info, new Random(), 2);
    }

    @Override
    public Object readStructureFromWorld(StructureReadMeta meta) throws Exception {
        WorldServer world = ((CraftWorld)Bukkit.getWorld((String)meta.getLocation().getWorldName())).getHandle();
        BlockPosition cornerBlock = new BlockPosition((int)meta.getLocation().getX(), (int)meta.getLocation().getY(), (int)meta.getLocation().getZ());
        BlockPosition offsetBlock = new BlockPosition((int)meta.getOffset().getX(), (int)meta.getOffset().getY(), (int)meta.getOffset().getZ());
        Block structureVoid = (Block)Blocks.class.getDeclaredField(meta.getStructureVoidTypeName()).get(null);
        DefinedStructure template = new DefinedStructure();
        template.a((World)world, cornerBlock, (BaseBlockPosition)offsetBlock, meta.isIncludeEntitiesEnabled(), structureVoid);
        template.a(meta.getAuthor());
        return template;
    }
}

