/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.structure.bukkit.v1_17_R1;

import com.shanebeestudios.skbee.api.structure.api.enumeration.StructureMirror;
import com.shanebeestudios.skbee.api.structure.api.enumeration.StructureMode;
import com.shanebeestudios.skbee.api.structure.api.enumeration.StructureRotation;
import com.shanebeestudios.skbee.api.structure.api.service.TypeConversionService;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;

public class TypeConversionServiceImpl
implements TypeConversionService {
    @Override
    public StructureMode convertToStructureMode(Object handle) {
        BlockPropertyStructureMode usageMode = (BlockPropertyStructureMode)handle;
        switch (usageMode) {
            case d: {
                return StructureMode.DATA;
            }
            case b: {
                return StructureMode.LOAD;
            }
            case a: {
                return StructureMode.SAVE;
            }
        }
        return StructureMode.CORNER;
    }

    @Override
    public StructureMirror convertToStructureMirror(Object handle) {
        EnumBlockMirror mirror = (EnumBlockMirror)handle;
        switch (mirror) {
            case c: {
                return StructureMirror.FRONT_BACK;
            }
            case b: {
                return StructureMirror.LEFT_RIGHT;
            }
        }
        return StructureMirror.NONE;
    }

    @Override
    public StructureRotation convertToStructureRotation(Object handle) {
        EnumBlockRotation rotation = (EnumBlockRotation)handle;
        switch (rotation) {
            case b: {
                return StructureRotation.ROTATION_90;
            }
            case c: {
                return StructureRotation.ROTATION_180;
            }
            case d: {
                return StructureRotation.ROTATION_270;
            }
        }
        return StructureRotation.NONE;
    }

    @Override
    public Object convertToStructureModeHandle(StructureMode mode) {
        switch (mode) {
            case SAVE: {
                return BlockPropertyStructureMode.a;
            }
            case DATA: {
                return BlockPropertyStructureMode.d;
            }
            case LOAD: {
                return BlockPropertyStructureMode.b;
            }
        }
        return BlockPropertyStructureMode.c;
    }

    @Override
    public Object convertToMirrorHandle(StructureMirror mirror) {
        switch (mirror) {
            case FRONT_BACK: {
                return EnumBlockMirror.c;
            }
            case LEFT_RIGHT: {
                return EnumBlockMirror.b;
            }
        }
        return EnumBlockMirror.a;
    }

    @Override
    public Object convertToRotationHandle(StructureRotation rotation) {
        switch (rotation) {
            case ROTATION_90: {
                return EnumBlockRotation.b;
            }
            case ROTATION_180: {
                return EnumBlockRotation.c;
            }
            case ROTATION_270: {
                return EnumBlockRotation.d;
            }
        }
        return EnumBlockRotation.a;
    }
}

