/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.structure.bukkit.v1_9_R2;

import com.shanebeestudios.skbee.api.structure.api.entity.StructurePlaceMeta;
import com.shanebeestudios.skbee.api.structure.api.entity.StructureReadMeta;
import com.shanebeestudios.skbee.api.structure.api.service.StructureWorldService;
import com.shanebeestudios.skbee.api.structure.api.service.TypeConversionService;
import net.minecraft.server.v1_9_R2.Block;
import net.minecraft.server.v1_9_R2.BlockPosition;
import net.minecraft.server.v1_9_R2.Blocks;
import net.minecraft.server.v1_9_R2.DefinedStructure;
import net.minecraft.server.v1_9_R2.DefinedStructureInfo;
import net.minecraft.server.v1_9_R2.EnumBlockMirror;
import net.minecraft.server.v1_9_R2.EnumBlockRotation;
import net.minecraft.server.v1_9_R2.World;
import net.minecraft.server.v1_9_R2.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_9_R2.CraftWorld;

public class StructureWorldServiceImpl
implements StructureWorldService {
    private final TypeConversionService conversionService;

    public StructureWorldServiceImpl(TypeConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public void placeStructureToWorld(StructurePlaceMeta meta, Object structure) throws Exception {
        if (!(structure instanceof DefinedStructure)) {
            throw new IllegalArgumentException("DefinedStructure has to be an NMS handle!");
        }
        DefinedStructure definedStructure = (DefinedStructure)structure;
        WorldServer world = ((CraftWorld)Bukkit.getWorld((String)meta.getLocation().getWorldName())).getHandle();
        BlockPosition cornerBlock = new BlockPosition((int)meta.getLocation().getX(), (int)meta.getLocation().getY(), (int)meta.getLocation().getZ());
        DefinedStructureInfo info = new DefinedStructureInfo();
        info.a(!meta.isIncludeEntitiesEnabled());
        info.a((EnumBlockMirror)this.conversionService.convertToMirrorHandle(meta.getMirrorType()));
        info.a((EnumBlockRotation)this.conversionService.convertToRotationHandle(meta.getRotationType()));
        definedStructure.a((World)world, cornerBlock, info);
    }

    @Override
    public Object readStructureFromWorld(StructureReadMeta meta) throws Exception {
        WorldServer world = ((CraftWorld)Bukkit.getWorld((String)meta.getLocation().getWorldName())).getHandle();
        BlockPosition cornerBlock = new BlockPosition((int)meta.getLocation().getX(), (int)meta.getLocation().getY(), (int)meta.getLocation().getZ());
        BlockPosition offsetBlock = new BlockPosition((int)meta.getOffset().getX(), (int)meta.getOffset().getY(), (int)meta.getOffset().getZ());
        Block structureVoid = (Block)Blocks.class.getDeclaredField(meta.getStructureVoidTypeName()).get(null);
        DefinedStructure definedStructure = new DefinedStructure();
        definedStructure.a((World)world, cornerBlock, offsetBlock, meta.isIncludeEntitiesEnabled(), structureVoid);
        definedStructure.a(meta.getAuthor());
        return definedStructure;
    }
}

