/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.structure.core.entity;

import com.shanebeestudios.skbee.api.structure.api.entity.ProgressToken;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;

public class ProgressTokenImpl<T>
implements ProgressToken<T> {
    private final Set<Consumer<Double>> progressConsumers = new HashSet<Consumer<Double>>();
    private final CompletionStage<T> item;
    private volatile boolean cancelled = false;

    public ProgressTokenImpl(CompletionStage<T> item) {
        this.item = item;
    }

    public void progress(double progress) {
        this.progressConsumers.forEach(e -> e.accept(progress));
    }

    @Override
    public CompletionStage<T> getCompletionStage() {
        return this.item;
    }

    @Override
    public ProgressToken<T> onProgress(Consumer<Double> progress) {
        this.progressConsumers.add(progress);
        return this;
    }

    @Override
    public ProgressToken<T> onException(Consumer<Throwable> exception) {
        this.item.exceptionally(e -> {
            exception.accept((Throwable)e);
            return null;
        });
        return this;
    }

    @Override
    public ProgressToken<T> onResult(Consumer<T> result) {
        this.item.thenAccept(result);
        return this;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }
}

