/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.structure.core.entity;

import com.shanebeestudios.skbee.api.structure.api.entity.Position;
import com.shanebeestudios.skbee.api.structure.api.entity.ProgressToken;
import com.shanebeestudios.skbee.api.structure.api.entity.StructureReadMeta;
import com.shanebeestudios.skbee.api.structure.api.entity.StructureSaverAbstract;
import com.shanebeestudios.skbee.api.structure.api.enumeration.StructureRestriction;
import com.shanebeestudios.skbee.api.structure.api.enumeration.Version;
import com.shanebeestudios.skbee.api.structure.api.service.ProxyService;
import com.shanebeestudios.skbee.api.structure.api.service.StructureSerializationService;
import com.shanebeestudios.skbee.api.structure.api.service.StructureWorldService;
import com.shanebeestudios.skbee.api.structure.core.entity.PositionImpl;
import com.shanebeestudios.skbee.api.structure.core.entity.ProgressTokenImpl;
import com.shanebeestudios.skbee.api.structure.core.entity.StructureReadMetaImpl;
import com.shanebeestudios.skbee.api.structure.lib.org.jetbrains.annotations.NotNull;
import com.shanebeestudios.skbee.api.structure.lib.org.jetbrains.annotations.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;

public class StructureSaverAbstractImpl<L, V>
implements StructureSaverAbstract<L, V> {
    private final ProxyService proxyService;
    private final StructureSerializationService serializationService;
    private final StructureWorldService worldService;
    private Position location;
    private Position offset;
    private String author;
    private boolean includeEntities = false;
    private StructureRestriction structureRestriction = StructureRestriction.SINGLE_32;
    private String structureVoid;

    public StructureSaverAbstractImpl(ProxyService proxyService, StructureSerializationService serializationService, StructureWorldService worldService) {
        this.proxyService = proxyService;
        this.serializationService = serializationService;
        this.worldService = worldService;
        this.structureVoid = proxyService.getServerVersion().isVersionSameOrGreaterThan(Version.VERSION_1_17_R1) ? "jb" : (proxyService.getServerVersion().isVersionSameOrGreaterThan(Version.VERSION_1_13_R2) ? "STRUCTURE_VOID" : (proxyService.getServerVersion().isVersionSameOrGreaterThan(Version.VERSION_1_10_R1) ? "dj" : "BARRIER"));
    }

    @Override
    @Nullable
    public L getLocation() {
        if (this.location == null) {
            return null;
        }
        return this.proxyService.toLocation(this.location);
    }

    @Override
    @Nullable
    public V getOffset() {
        if (this.offset == null) {
            return null;
        }
        return this.proxyService.toVector(this.offset);
    }

    @Override
    @Nullable
    public String getAuthor() {
        return this.author;
    }

    @Override
    public boolean isIncludeEntitiesEnabled() {
        return this.includeEntities;
    }

    @Override
    @NotNull
    public StructureRestriction getRestriction() {
        return this.structureRestriction;
    }

    @Override
    @NotNull
    public String getStructureVoidTypeName() {
        return this.structureVoid;
    }

    @Override
    @NotNull
    public StructureSaverAbstract<L, V> at(@Nullable L location) {
        this.location = this.proxyService.toPosition(location);
        return this;
    }

    @Override
    @NotNull
    public StructureSaverAbstract<L, V> offSet(@Nullable V vector) {
        this.offset = this.proxyService.toPosition(vector);
        return this;
    }

    @Override
    @NotNull
    public StructureSaverAbstract<L, V> sizeX(int x) {
        if (this.offset == null) {
            this.offset = new PositionImpl();
        }
        this.offset.setX(x);
        return this;
    }

    @Override
    @NotNull
    public StructureSaverAbstract<L, V> sizeY(int y) {
        if (this.offset == null) {
            this.offset = new PositionImpl();
        }
        this.offset.setY(y);
        return this;
    }

    @Override
    @NotNull
    public StructureSaverAbstract<L, V> sizeZ(int z) {
        if (this.offset == null) {
            this.offset = new PositionImpl();
        }
        this.offset.setZ(z);
        return this;
    }

    @Override
    public StructureSaverAbstract<L, V> author(@Nullable String author) {
        this.author = author;
        return this;
    }

    @Override
    public StructureSaverAbstract<L, V> includeEntities(boolean enabled) {
        this.includeEntities = enabled;
        return this;
    }

    @Override
    @NotNull
    public StructureSaverAbstract<L, V> restriction(@NotNull StructureRestriction structureRestriction) {
        this.structureRestriction = structureRestriction;
        return this;
    }

    @Override
    @NotNull
    public StructureSaverAbstract<L, V> structureVoidTypeName(@NotNull String name) {
        this.structureVoid = name;
        return this;
    }

    @Override
    @NotNull
    public ProgressToken<Void> saveToWorld(@NotNull String worldName, @NotNull String author, @NotNull String name) {
        Version version = this.proxyService.getServerVersion();
        File file = version.isVersionSameOrGreaterThan(Version.VERSION_1_13_R2) ? new File(worldName + File.separator + "generated" + File.separator + author + File.separator + "structures" + File.separator + name + ".nbt") : new File(worldName + File.separator + "structures" + File.separator + name + ".nbt");
        try {
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.author(author);
        return this.saveToFile(file);
    }

    @Override
    @NotNull
    public ProgressToken<String> saveToString() {
        CompletableFuture completableFuture = new CompletableFuture();
        ProgressTokenImpl<String> rootToken = new ProgressTokenImpl<String>(completableFuture);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ProgressToken<Void> innerToken = this.saveToOutputStream(byteArrayOutputStream);
        innerToken.onProgress(rootToken::progress);
        innerToken.getCompletionStage().thenAccept(e -> {
            try {
                String data = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
                byteArrayOutputStream.close();
                completableFuture.complete(data);
            }
            catch (IOException ioException) {
                completableFuture.completeExceptionally(ioException);
            }
        });
        innerToken.getCompletionStage().exceptionally(e -> {
            completableFuture.completeExceptionally((Throwable)e);
            return null;
        });
        return rootToken;
    }

    @Override
    @NotNull
    public ProgressToken<Void> saveToPath(@NotNull Path target) {
        return this.saveToFile(target.toFile());
    }

    @Override
    @NotNull
    public ProgressToken<Void> saveToFile(@NotNull File target) {
        CompletableFuture completableFuture = new CompletableFuture();
        ProgressTokenImpl<Void> rootToken = new ProgressTokenImpl<Void>(completableFuture);
        this.proxyService.runAsyncTask(() -> {
            try {
                FileOutputStream outputStream = new FileOutputStream(target);
                ProgressToken<Void> progressToken = this.saveToOutputStream(outputStream);
                progressToken.onProgress(rootToken::progress);
                progressToken.getCompletionStage().thenAccept(c -> {
                    try {
                        outputStream.close();
                        completableFuture.complete(c);
                    }
                    catch (IOException e) {
                        completableFuture.completeExceptionally(e);
                    }
                });
                progressToken.getCompletionStage().exceptionally(throwable -> {
                    completableFuture.completeExceptionally((Throwable)throwable);
                    return null;
                });
            }
            catch (IOException e) {
                this.proxyService.runSyncTask(() -> completableFuture.completeExceptionally(e));
            }
        });
        return rootToken;
    }

    @Override
    @NotNull
    public ProgressToken<Void> saveToOutputStream(@NotNull OutputStream target) {
        StructureReadMeta meta = this.validate();
        CompletableFuture completableFuture = new CompletableFuture();
        ProgressTokenImpl<Void> progressToken = new ProgressTokenImpl<Void>(completableFuture);
        this.proxyService.runSyncTask(() -> {
            Object definedStructure;
            progressToken.progress(0.0);
            try {
                definedStructure = this.worldService.readStructureFromWorld(meta);
            }
            catch (Exception e) {
                completableFuture.completeExceptionally(e);
                return;
            }
            progressToken.progress(0.5);
            Object finalDefinedStructure = definedStructure;
            this.proxyService.runAsyncTask(() -> {
                try {
                    this.serializationService.serialize(finalDefinedStructure, target);
                    this.proxyService.runSyncTask(() -> {
                        completableFuture.complete(null);
                        progressToken.progress(1.0);
                    });
                }
                catch (IOException e) {
                    this.proxyService.runSyncTask(() -> completableFuture.completeExceptionally(e));
                }
            });
        });
        return progressToken;
    }

    private StructureReadMeta validate() {
        if (this.location == null) {
            throw new IllegalArgumentException("Location #at(Location) cannot be null!");
        }
        if (this.offset == null) {
            throw new IllegalArgumentException("Offset #offset(Location) cannot be null!");
        }
        StructureReadMeta structureReadMeta = this.createReadMeta();
        this.changeOffSetToPositivOffset(structureReadMeta.getLocation(), structureReadMeta.getOffset());
        this.validateDirection("x", structureReadMeta.getLocation().getX(), structureReadMeta.getOffset().getX());
        this.validateDirection("y", structureReadMeta.getLocation().getY(), structureReadMeta.getOffset().getY());
        this.validateDirection("z", structureReadMeta.getLocation().getZ(), structureReadMeta.getOffset().getZ());
        return structureReadMeta;
    }

    private StructureReadMeta createReadMeta() {
        StructureReadMetaImpl readMeta = new StructureReadMetaImpl();
        readMeta.location = new PositionImpl(this.location);
        readMeta.offset = new PositionImpl(this.offset);
        readMeta.includeEntities = this.includeEntities;
        readMeta.structureVoid = this.structureVoid;
        if (this.author != null) {
            readMeta.author = this.author;
        }
        return readMeta;
    }

    private void validateDirection(String direction, double source, double offset) {
        double diff = (int)Math.abs(source - (source + offset));
        if (this.structureRestriction == StructureRestriction.SINGLE_32) {
            if (diff > 32.0) {
                throw new IllegalArgumentException("Axe " + direction + " exceeded StructureRestriction of 32x32x32! Change the restriction or reduce the size of your selection.");
            }
            return;
        }
        if (this.structureRestriction == StructureRestriction.SINGLE_48 && diff > 48.0) {
            throw new IllegalArgumentException("Axe " + direction + " exceeded StructureRestriction of 48x48x48! Change the restriction or reduce the size of your selection.");
        }
    }

    private void changeOffSetToPositivOffset(Position source, Position offSet) {
        if (offSet.getX() < 0.0) {
            source.setX(source.getX() + offSet.getX() + 1.0);
            offSet.setX(offSet.getX() * -1.0);
        }
        if (offSet.getY() < 0.0) {
            source.setY(source.getY() + offSet.getY() + 1.0);
            offSet.setY(offSet.getY() * -1.0);
        }
        if (offSet.getZ() < 0.0) {
            source.setZ(source.getZ() + offSet.getZ() + 1.0);
            offSet.setZ(offSet.getZ() * -1.0);
        }
    }
}

