/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.util;

import ch.njol.skript.localization.Language;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class EnumUtils<E extends Enum<E>> {
    private final Class<E> c;
    @Nullable
    private final String languageNode;
    private String[] names;
    private final HashMap<String, E> parseMap = new HashMap();

    public EnumUtils(@NonNull Class<E> c, @NonNull String languageNode) {
        assert (c.isEnum());
        assert (!languageNode.isEmpty() && !languageNode.endsWith(".")) : languageNode;
        this.c = c;
        this.languageNode = languageNode;
        this.names = new String[((Enum[])c.getEnumConstants()).length];
        Language.addListener(() -> this.validate(true));
    }

    public EnumUtils(@NonNull Class<E> c) {
        assert (c.isEnum());
        this.c = c;
        this.languageNode = null;
        this.names = new String[((Enum[])c.getEnumConstants()).length];
        for (Enum enumConstant : (Enum[])c.getEnumConstants()) {
            String name = enumConstant.name().toLowerCase(Locale.ROOT).replace("_", " ");
            this.parseMap.put(name, enumConstant);
            this.names[enumConstant.ordinal()] = name;
        }
    }

    public EnumUtils(@NonNull Class<E> c, @Nullable String prefix, @Nullable String suffix) {
        assert (c.isEnum());
        this.c = c;
        this.languageNode = null;
        this.names = new String[((Enum[])c.getEnumConstants()).length];
        for (Enum enumConstant : (Enum[])c.getEnumConstants()) {
            String name = enumConstant.name().toLowerCase(Locale.ROOT).replace("_", " ");
            if (prefix != null && !name.startsWith(prefix)) {
                name = prefix + " " + name;
            }
            if (suffix != null && !name.endsWith(suffix)) {
                name = name + " " + suffix;
            }
            this.parseMap.put(name, enumConstant);
            this.names[enumConstant.ordinal()] = name;
        }
    }

    void validate(boolean force) {
        boolean update = force;
        int newL = ((Enum[])this.c.getEnumConstants()).length;
        if (newL > this.names.length) {
            this.names = new String[newL];
            update = true;
        }
        if (update) {
            this.parseMap.clear();
            for (Enum e : (Enum[])this.c.getEnumConstants()) {
                if (this.languageNode != null) {
                    String[] ls = Language.getList((String)(this.languageNode + "." + e.name()));
                    this.names[e.ordinal()] = ls[0];
                    for (String l : ls) {
                        this.parseMap.put(l.toLowerCase(), e);
                    }
                    continue;
                }
                String name = e.name().toLowerCase(Locale.ROOT).replace("_", " ");
                this.parseMap.put(name, e);
                this.names[e.ordinal()] = name;
            }
        }
    }

    @Nullable
    public final E parse(String s) {
        this.validate(false);
        return (E)((Enum)this.parseMap.get(s.toLowerCase(Locale.ROOT)));
    }

    public String toString(E e, int flags) {
        this.validate(false);
        return this.names[((Enum)e).ordinal()];
    }

    public String getAllNames() {
        this.validate(false);
        ArrayList names = new ArrayList();
        Collections.addAll(names, this.names);
        Collections.sort(names);
        return StringUtils.join(names, (String)", ");
    }
}

