/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.util;

import ch.njol.skript.Skript;
import ch.njol.skript.log.ErrorQuality;
import com.shanebeestudios.skbee.SkBee;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;

public class Util {
    private static final String PREFIX = "&7[&bSk&3Bee&7] ";
    private static final String PREFIX_ERROR = "&7[&bSk&3Bee &cERROR&7] ";
    private static final Pattern HEX_PATTERN = Pattern.compile("<#([A-Fa-f0-9]){6}>");

    public static String getColString(String string) {
        Matcher matcher = HEX_PATTERN.matcher(string);
        if (Skript.isRunningMinecraft((int)1, (int)16)) {
            while (matcher.find()) {
                ChatColor hexColor = ChatColor.of((String)matcher.group().substring(1, matcher.group().length() - 1));
                String before = string.substring(0, matcher.start());
                String after = string.substring(matcher.end());
                string = before + hexColor + after;
                matcher = HEX_PATTERN.matcher(string);
            }
        } else {
            string = HEX_PATTERN.matcher(string).replaceAll("");
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static void log(String log) {
        Bukkit.getConsoleSender().sendMessage(Util.getColString(PREFIX + log));
    }

    public static void log(String format, Object ... objects) {
        Util.log(String.format(format, objects));
    }

    public static void skriptError(String error) {
        Skript.error((String)Util.getColString(PREFIX_ERROR + error), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
    }

    public static void skriptError(String format, Object ... objects) {
        Util.skriptError(String.format(format, objects));
    }

    public static void debug(String debug) {
        if (SkBee.getPlugin().getPluginConfig().SETTINGS_DEBUG) {
            Bukkit.getConsoleSender().sendMessage(Util.getColString(PREFIX_ERROR + debug));
        }
    }

    public static void debug(String format, Object ... objects) {
        Util.debug(String.format(format, objects));
    }

    public static int[] uuidToIntArray(String uuid) {
        return Util.uuidToIntArray(UUID.fromString(uuid));
    }

    public static int[] uuidToIntArray(UUID uuid) {
        long most = uuid.getMostSignificantBits();
        long least = uuid.getLeastSignificantBits();
        return new int[]{(int)(most >> 32), (int)most, (int)(least >> 32), (int)least};
    }
}

