/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.virtualfurnace.api;

import com.shanebeestudios.skbee.api.virtualfurnace.api.FurnaceManager;
import com.shanebeestudios.skbee.api.virtualfurnace.api.RecipeManager;
import com.shanebeestudios.skbee.api.virtualfurnace.api.TileManager;
import com.shanebeestudios.skbee.api.virtualfurnace.api.VirtualFurnaceAPI;
import com.shanebeestudios.skbee.api.virtualfurnace.api.chunk.VirtualChunk;
import com.shanebeestudios.skbee.api.virtualfurnace.api.event.machine.FurnaceExtractEvent;
import com.shanebeestudios.skbee.api.virtualfurnace.api.machine.Furnace;
import com.shanebeestudios.skbee.api.virtualfurnace.api.machine.Machine;
import com.shanebeestudios.skbee.api.virtualfurnace.api.recipe.Fuel;
import com.shanebeestudios.skbee.api.virtualfurnace.api.tile.Tile;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Chunk;
import org.bukkit.block.Block;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

class FurnaceListener
implements Listener {
    private final FurnaceManager furnaceManager;
    private final RecipeManager recipeManager;
    private final TileManager tileManager;
    private final Map<HumanEntity, Machine> openInventories = new HashMap<HumanEntity, Machine>();

    FurnaceListener(VirtualFurnaceAPI virtualFurnaceAPI) {
        this.furnaceManager = virtualFurnaceAPI.getFurnaceManager();
        this.recipeManager = virtualFurnaceAPI.getRecipeManager();
        this.tileManager = virtualFurnaceAPI.getTileManager();
    }

    @EventHandler
    private void onClickFurnace(PlayerInteractEvent event) {
        Tile<?> tile;
        Furnace furnace;
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack hand = event.getItem();
        Player player = event.getPlayer();
        if (hand != null && (furnace = this.furnaceManager.getFurnaceFromItemStack(hand)) != null) {
            event.setCancelled(true);
            furnace.openInventory(player);
            this.openInventories.put((HumanEntity)player, furnace);
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Chunk chunk = block.getChunk();
        VirtualChunk virtualChunk = this.tileManager.getChunk(chunk);
        if (virtualChunk != null && (tile = virtualChunk.getTile(block)) != null) {
            event.setCancelled(true);
            if (event.getHand() != EquipmentSlot.OFF_HAND) {
                tile.activate(player);
                this.openInventories.put((HumanEntity)player, (Machine)tile.getMachine());
            }
        }
    }

    @EventHandler
    private void onCloseInventory(InventoryCloseEvent event) {
        HumanEntity player = event.getPlayer();
        this.openInventories.remove(player);
    }

    @EventHandler
    private void onInventoryClick(InventoryClickEvent event) {
        HumanEntity clicker = event.getWhoClicked();
        if (this.openInventories.containsKey(clicker) && clicker instanceof Player) {
            ItemStack cursor;
            Fuel fuel;
            Furnace furnace = (Furnace)this.openInventories.get(clicker);
            int slot = event.getRawSlot();
            if (slot == 2) {
                ItemStack output = furnace.getOutput();
                if (output != null) {
                    int exp = (int)furnace.extractExperience();
                    FurnaceExtractEvent extractEvent = new FurnaceExtractEvent(furnace, (Player)clicker, output, exp);
                    extractEvent.callEvent();
                    ((Player)clicker).giveExp(extractEvent.getExperience());
                    event.setCurrentItem(extractEvent.getItemStack());
                }
            } else if (slot == 1 && (fuel = this.recipeManager.getFuelByMaterial((cursor = clicker.getItemOnCursor()).getType())) != null && this.isNotVanillaFuel(cursor)) {
                ItemStack furnaceFuel = furnace.getFuel();
                event.setCancelled(true);
                if (furnaceFuel != null && furnaceFuel.getType() == cursor.getType()) {
                    InventoryView view = event.getView();
                    int fuelAmount = furnaceFuel.getAmount();
                    int cursorAmount = cursor.getAmount();
                    int maxStack = cursor.getType().getMaxStackSize();
                    ItemStack fuelSlot = view.getItem(1);
                    assert (fuelSlot != null);
                    if (fuelAmount < maxStack) {
                        int diff = maxStack - fuelAmount;
                        if (cursorAmount < diff) {
                            cursor.setAmount(0);
                            fuelSlot.setAmount(fuelAmount + cursorAmount);
                        } else {
                            cursor.setAmount(cursorAmount - diff);
                            fuelSlot.setAmount(maxStack);
                        }
                        ((Player)clicker).updateInventory();
                    }
                } else {
                    ItemStack oldCursor = cursor.clone();
                    clicker.setItemOnCursor(furnaceFuel);
                    event.getView().setItem(1, oldCursor);
                }
            }
        }
    }

    private boolean isNotVanillaFuel(ItemStack itemStack) {
        for (Fuel fuel : Fuel.getVanillaFuels()) {
            if (fuel.getFuelMaterial() != itemStack.getType()) continue;
            return false;
        }
        return true;
    }

    @EventHandler
    private void onChunkLoad(ChunkLoadEvent event) {
        this.handleChunk(event.getChunk(), true);
    }

    @EventHandler
    private void onChunkUnload(ChunkUnloadEvent event) {
        this.handleChunk(event.getChunk(), false);
    }

    private void handleChunk(Chunk chunk, boolean load) {
        VirtualChunk virtualChunk = this.tileManager.getChunk(chunk);
        if (virtualChunk != null) {
            if (load) {
                if (virtualChunk.isLoaded()) {
                    return;
                }
                this.tileManager.loadChunk(virtualChunk);
            } else {
                if (virtualChunk.isForceLoaded()) {
                    return;
                }
                this.tileManager.unloadChunk(virtualChunk);
            }
        }
    }
}

