/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.virtualfurnace.api;

import com.shanebeestudios.skbee.api.virtualfurnace.api.FurnaceListener;
import com.shanebeestudios.skbee.api.virtualfurnace.api.FurnaceManager;
import com.shanebeestudios.skbee.api.virtualfurnace.api.Metrics;
import com.shanebeestudios.skbee.api.virtualfurnace.api.RecipeManager;
import com.shanebeestudios.skbee.api.virtualfurnace.api.TileManager;
import com.shanebeestudios.skbee.api.virtualfurnace.api.machine.Furnace;
import com.shanebeestudios.skbee.api.virtualfurnace.api.property.FurnaceProperties;
import com.shanebeestudios.skbee.api.virtualfurnace.api.task.FurnaceTick;
import com.shanebeestudios.skbee.api.virtualfurnace.api.task.TileTick;
import com.shanebeestudios.skbee.api.virtualfurnace.api.tile.FurnaceTile;
import com.shanebeestudios.skbee.api.virtualfurnace.api.util.Util;
import java.io.IOException;
import java.util.Properties;
import org.bukkit.Bukkit;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class VirtualFurnaceAPI {
    private boolean enabled = true;
    private static VirtualFurnaceAPI instance;
    private final String apiVersion;
    private final JavaPlugin plugin;
    private RecipeManager recipeManager;
    private FurnaceManager furnaceManager;
    private TileManager tileManager;
    private FurnaceTick furnaceTick;
    private TileTick tileTick;

    public VirtualFurnaceAPI(JavaPlugin javaPlugin) {
        this(javaPlugin, false);
    }

    public VirtualFurnaceAPI(@NotNull JavaPlugin javaPlugin, boolean disableMetrics) {
        instance = this;
        this.plugin = javaPlugin;
        this.apiVersion = this.getVersion();
        if (!Util.classExists("org.bukkit.persistence.PersistentDataHolder")) {
            this.recipeManager = null;
            this.furnaceManager = null;
            this.tileManager = null;
            this.furnaceTick = null;
            this.tileTick = null;
            Util.error("&cFailed to initialize VirtualFurnaceAPI");
            Util.error("&7  - Bukkit version: &b" + Bukkit.getBukkitVersion() + " &7is not supported!");
            this.enabled = false;
            return;
        }
        if (!disableMetrics) {
            new Metrics((Plugin)javaPlugin, 7021, this);
        }
        this.recipeManager = new RecipeManager();
        this.furnaceManager = new FurnaceManager(this);
        this.tileManager = new TileManager(this);
        this.tileManager.load();
        this.furnaceTick = new FurnaceTick(this);
        this.furnaceTick.start();
        this.tileTick = new TileTick(this);
        this.tileTick.start();
        Bukkit.getPluginManager().registerEvents((Listener)new FurnaceListener(this), (Plugin)javaPlugin);
        Util.log("Initialized VirtualFurnaceAPI version: &b" + this.getVersion());
    }

    public void disableAPI() {
        this.furnaceTick.cancel();
        this.tileTick.cancel();
        this.furnaceTick = null;
        this.tileTick = null;
        this.furnaceManager.shutdown();
        this.tileManager.shutdown();
        this.furnaceManager = null;
        this.tileManager = null;
        this.recipeManager = null;
        Util.log("Shut down API!");
    }

    public void disableFurnaceTick() {
        this.furnaceTick.cancel();
    }

    public static VirtualFurnaceAPI getInstance() {
        return instance;
    }

    public JavaPlugin getJavaPlugin() {
        return this.plugin;
    }

    public RecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    public FurnaceManager getFurnaceManager() {
        return this.furnaceManager;
    }

    public TileManager getTileManager() {
        return this.tileManager;
    }

    public FurnaceTick getFurnaceTick() {
        return this.furnaceTick;
    }

    public String getAPIVersion() {
        return this.apiVersion;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private String getVersion() {
        Properties prop = new Properties();
        try {
            prop.load(this.getJavaPlugin().getResource("VirtualFurnace.properties"));
            return prop.getProperty("api-version");
        }
        catch (IOException e) {
            return "unknown-version";
        }
    }

    static {
        ConfigurationSerialization.registerClass(Furnace.class, (String)"furnace");
        ConfigurationSerialization.registerClass(FurnaceProperties.class, (String)"furnace_properties");
        ConfigurationSerialization.registerClass(FurnaceTile.class, (String)"tile");
    }
}

