/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.virtualfurnace.api.chunk;

import com.shanebeestudios.skbee.api.virtualfurnace.api.VirtualFurnaceAPI;
import com.shanebeestudios.skbee.api.virtualfurnace.api.tile.Tile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;

public class VirtualChunk {
    private final List<Tile<?>> tiles = new ArrayList();
    private final List<String> tickets = new ArrayList<String>();
    private final int x;
    private final int z;
    private final World world;

    public VirtualChunk(int x, int z, World world) {
        this.x = x;
        this.z = z;
        this.world = world;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public World getWorld() {
        return this.world;
    }

    public Chunk getBukkitChunk() {
        return this.world.getChunkAt(this.x, this.z);
    }

    public List<Tile<?>> getTiles() {
        return this.tiles;
    }

    public Tile<?> getTile(@NotNull Block block) {
        for (Tile<?> tile : this.tiles) {
            if (tile.getX() != block.getX() || tile.getY() != block.getY() || tile.getZ() != block.getZ()) continue;
            return tile;
        }
        return null;
    }

    public boolean addTile(@NotNull Tile<?> tile) {
        if (!this.tiles.contains(tile)) {
            this.tiles.add(tile);
            return true;
        }
        return false;
    }

    public boolean removeTile(@NotNull Tile<?> tile) {
        if (this.tiles.contains(tile)) {
            this.tiles.remove(tile);
            return true;
        }
        return false;
    }

    public boolean isLoaded() {
        return VirtualFurnaceAPI.getInstance().getTileManager().isChunkLoaded(this);
    }

    public boolean isBukkitChunkLoaded() {
        return this.world.isChunkLoaded(this.x, this.z);
    }

    public Collection<Plugin> getPluginChunkTickets() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        for (String ticket : this.tickets) {
            Plugin plugin = pluginManager.getPlugin(ticket);
            if (plugin == null) continue;
            plugins.add(plugin);
        }
        return Collections.unmodifiableCollection(plugins);
    }

    public boolean addPluginChunkTicket(@NotNull Plugin plugin) {
        String p = plugin.getDescription().getName();
        if (!this.tickets.contains(p)) {
            this.tickets.add(p);
            if (!this.isLoaded()) {
                VirtualFurnaceAPI.getInstance().getTileManager().loadChunk(this);
            }
            return true;
        }
        return false;
    }

    public boolean removePluginChunkTicket(@NotNull Plugin plugin) {
        String p = plugin.getDescription().getName();
        if (this.tickets.contains(p)) {
            this.tickets.remove(p);
            if (this.tickets.isEmpty()) {
                VirtualFurnaceAPI.getInstance().getTileManager().unloadChunk(this);
            }
            return true;
        }
        return false;
    }

    public void removeAllPluginChunkTickets() {
        this.tickets.clear();
        VirtualFurnaceAPI.getInstance().getTileManager().unloadChunk(this);
    }

    public boolean isForceLoaded() {
        return !this.tickets.isEmpty();
    }

    public void tick() {
        for (Tile<?> tile : this.tiles) {
            tile.tick();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualChunk chunk = (VirtualChunk)o;
        return this.x == chunk.x && this.z == chunk.z && Objects.equals(this.tiles, chunk.tiles) && Objects.equals(this.tickets, chunk.tickets) && Objects.equals(this.world, chunk.world);
    }

    public int hashCode() {
        return Objects.hash(this.tiles, this.tickets, this.x, this.z, this.world);
    }

    public String toString() {
        return "VirtualChunk{, x=" + this.x + ", z=" + this.z + ", world=" + this.world.getName() + '}';
    }
}

