/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.virtualfurnace.api.tile;

import com.shanebeestudios.skbee.api.virtualfurnace.api.VirtualFurnaceAPI;
import com.shanebeestudios.skbee.api.virtualfurnace.api.machine.Machine;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class Tile<M extends Machine> {
    final M machine;
    final int x;
    final int y;
    final int z;
    final String world;
    private final BlockData blockData;

    Tile(@NotNull M machine, int x, int y, int z, @NotNull World world) {
        this(machine, world.getBlockAt(x, y, z));
    }

    Tile(@NotNull M machine, int x, int y, int z, @NotNull String world) {
        this.machine = machine;
        this.x = x;
        this.y = y;
        this.z = z;
        this.world = world;
        World bukkitWorld = Bukkit.getWorld((String)world);
        this.blockData = bukkitWorld != null ? bukkitWorld.getBlockAt(x, y, z).getBlockData() : null;
    }

    Tile(@NotNull M machine, @NotNull Block block) {
        this.machine = machine;
        this.x = block.getX();
        this.y = block.getY();
        this.z = block.getZ();
        this.world = block.getWorld().getName();
        this.blockData = block.getBlockData();
    }

    public M getMachine() {
        return this.machine;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public String getWorld() {
        return this.world;
    }

    public World getBukkitWorld() {
        return Bukkit.getWorld((String)this.world);
    }

    public Block getBlock() {
        return this.getBukkitWorld().getBlockAt(this.x, this.y, this.z);
    }

    public BlockData getBlockData() {
        return this.blockData;
    }

    public boolean blockDataMatches(@NotNull Block block) {
        return this.blockData.equals(block.getBlockData());
    }

    public void activate(@NotNull Player player) {
        ((Machine)this.machine).openInventory(player);
    }

    public void breakTile() {
        VirtualFurnaceAPI.getInstance().getTileManager().removeTile(this);
    }

    public void tick() {
        if (this.blockDataMatches(this.getBlock())) {
            ((Machine)this.machine).tick();
        } else {
            this.breakTile();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tile tile = (Tile)o;
        return this.x == tile.x && this.y == tile.y && this.z == tile.z && Objects.equals(this.machine, tile.machine) && Objects.equals(this.world, tile.world) && Objects.equals(this.blockData, tile.blockData);
    }

    public int hashCode() {
        return Objects.hash(this.machine, this.x, this.y, this.z, this.world, this.blockData);
    }

    public String getString() {
        return "Tile{machine-type=" + this.machine.getClass().getSimpleName() + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", world='" + this.world + '\'' + '}';
    }

    public String toString() {
        return "Tile{machine=" + this.machine + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", world='" + this.world + '\'' + ", blockData=" + this.blockData + '}';
    }
}

