/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.board.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.elements.board.objects.Board;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Board - Is on")
@Description(value={"Check if a player's scoreboard is currently toggled on or off."})
@Examples(value={"if scoreboard of player is on:", "\ttoggle scoreboard of player off", "if scoreboard of player is off:", "\ttoggle scoreboard of player on"})
@Since(value="1.0.0")
public class CondBoardOn
extends Condition {
    private Expression<Player> player;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.player = exprs[0];
        this.setNegated(i >= 1);
        return true;
    }

    public boolean check(Event event) {
        Player player = (Player)this.player.getSingle(event);
        if (player != null) {
            Board board = Board.getBoard(player);
            return board.isOn() ^ this.isNegated();
        }
        return false;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "scoreboard of " + this.player.toString(e, d) + " is " + (this.isNegated() ? "off" : "on");
    }

    static {
        Skript.registerCondition(CondBoardOn.class, (String[])new String[]{"[score]board of %player% is (on|true)", "[score]board of %player% is(n't| not) on", "[score]board of %player% is (off|false)"});
    }
}

