/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.board.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.elements.board.objects.Board;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

@Name(value="Board - Title")
@Description(value={"Set the title of a player's scoreboard."})
@Examples(value={"set title of player's scoreboard to \"MyServer\"", "set title of all players' scoreboards to \"Our Serberder!\""})
@Since(value="1.0.0")
public class EffBoardTitle
extends Effect {
    private Expression<Player> players;
    private Expression<String> title;

    public boolean init(Expression<?> @NotNull [] exprs, int i, @NotNull Kleenean kleenean, @NotNull SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.title = exprs[1];
        return true;
    }

    protected void execute(@NotNull Event event) {
        Player[] players = (Player[])this.players.getArray(event);
        String title = (String)this.title.getSingle(event);
        for (Player player : players) {
            Board board = Board.getBoard(player);
            if (board == null) continue;
            board.setTitle(title != null ? title : "");
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "set title of " + this.players.toString(e, d) + " scoreboard to " + this.title.toString(e, d);
    }

    static {
        Skript.registerEffect(EffBoardTitle.class, (String[])new String[]{"set title of %players%'[s] [score]board[s] to %string%", "set title of [score]board[s] of %players% to %string%"});
    }
}

