/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.board.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.elements.board.objects.Board;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

@Name(value="Board - Toggle")
@Description(value={"Toggle the scoreboard of a player on or off."})
@Examples(value={"toggle board of player", "if scoreboard of player is on:", "\ttoggle scoreboard of player off", "", "toggle scoreboards of all players off"})
@Since(value="1.0.0")
public class EffBoardToggle
extends Effect {
    private Expression<Player> players;
    private int parse;

    public boolean init(Expression<?> @NotNull [] exprs, int i, @NotNull Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.parse = parseResult.mark;
        return true;
    }

    protected void execute(@NotNull Event event) {
        Player[] players;
        block5: for (Player player : players = (Player[])this.players.getArray(event)) {
            Board board = Board.getBoard(player);
            if (board == null) continue;
            switch (this.parse) {
                case 0: {
                    board.toggle(!board.isOn());
                    continue block5;
                }
                case 1: {
                    board.toggle(true);
                    continue block5;
                }
                case 2: {
                    board.toggle(false);
                }
            }
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String toggle = this.parse == 1 ? " to on" : (this.parse == 2 ? " to off" : "");
        return "toggle scoreboard of " + this.players.toString(e, d) + toggle;
    }

    static {
        Skript.registerEffect(EffBoardToggle.class, (String[])new String[]{"toggle [score]board[s] of %players% [[to] (1\u00a6(on|true)|2\u00a6(off|false))]", "toggle %players%'[s] [score]board[s] [[to] (1\u00a6(on|true)|2\u00a6(off|false))]"});
    }
}

