/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bound.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import com.shanebeestudios.skbee.api.event.EnterBoundEvent;
import com.shanebeestudios.skbee.api.event.ExitBoundEvent;
import com.shanebeestudios.skbee.elements.bound.objects.Bound;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

public class BoundEvents
extends SkriptEvent {
    private Literal<String> boundID;

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.boundID = args[0];
        return true;
    }

    public boolean check(Event event) {
        if (this.boundID == null) {
            return true;
        }
        return this.boundID.check(event, boundID -> {
            if (event instanceof EnterBoundEvent) {
                EnterBoundEvent enterBoundEvent = (EnterBoundEvent)event;
                return enterBoundEvent.getBound().getId().equals(boundID);
            }
            if (event instanceof ExitBoundEvent) {
                ExitBoundEvent exitBoundEvent = (ExitBoundEvent)event;
                return exitBoundEvent.getBound().getId().equals(boundID);
            }
            return false;
        });
    }

    public String toString(@Nullable Event e, boolean d) {
        return "bound enter/exit" + (this.boundID != null ? " with id " + this.boundID.toString(e, d) : "");
    }

    static {
        Skript.registerEvent((String)"Bound - Enter", BoundEvents.class, EnterBoundEvent.class, (String[])new String[]{"(bound enter|enter bound) [with id %-string%]"}).description(new String[]{"Called when a player enters a bound. Optional ID of bound. 'event-string' = bound ID."}).examples(new String[]{"on bound enter:", "\tif event-bound = {bounds::spawn}:", "\t\tsend \"You entered spawn!\"", "on enter bound with id \"spawn\":", "\tcancel event"}).since("1.0.0, 1.12.2 (Bound IDs)");
        EventValues.registerEventValue(EnterBoundEvent.class, Player.class, (Getter)new Getter<Player, EnterBoundEvent>(){

            public Player get(EnterBoundEvent event) {
                return event.getPlayer();
            }
        }, (int)0);
        EventValues.registerEventValue(EnterBoundEvent.class, Bound.class, (Getter)new Getter<Bound, EnterBoundEvent>(){

            public Bound get(EnterBoundEvent event) {
                return event.getBound();
            }
        }, (int)0);
        EventValues.registerEventValue(EnterBoundEvent.class, String.class, (Getter)new Getter<String, EnterBoundEvent>(){

            @Nullable
            public String get(EnterBoundEvent event) {
                return event.getBound().getId();
            }
        }, (int)0);
        Skript.registerEvent((String)"Bound - Exit", BoundEvents.class, ExitBoundEvent.class, (String[])new String[]{"(bound exit|exit bound) [with id %-string%]"}).description(new String[]{"Called when a player exits a bound. Optional ID of bound. 'event-string' = bound ID."}).examples(new String[]{"on bound exit:", "\tsend \"You left a bound\"", "\tif event-bound = {bound}:", "\t\tsend \"You left Spawn!\"", "on exit bound with id \"spawn\":", "\tcancel event"}).since("1.0.0, 1.12.2 (Bound IDs)");
        EventValues.registerEventValue(ExitBoundEvent.class, Player.class, (Getter)new Getter<Player, ExitBoundEvent>(){

            public Player get(ExitBoundEvent event) {
                return event.getPlayer();
            }
        }, (int)0);
        EventValues.registerEventValue(ExitBoundEvent.class, Bound.class, (Getter)new Getter<Bound, ExitBoundEvent>(){

            public Bound get(ExitBoundEvent event) {
                return event.getBound();
            }
        }, (int)0);
        EventValues.registerEventValue(ExitBoundEvent.class, String.class, (Getter)new Getter<String, ExitBoundEvent>(){

            @Nullable
            public String get(ExitBoundEvent event) {
                return event.getBound().getId();
            }
        }, (int)0);
    }
}

