/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bound.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.elements.bound.objects.Bound;
import org.bukkit.event.Event;

@Name(value="Bound - From ID")
@Description(value={"Get a bound object from a bound ID"})
@Examples(value={"set {_b} to bound from id \"%player%.home\""})
@Since(value="1.0.0")
public class ExprBoundFromID
extends SimpleExpression<Bound> {
    private Expression<String> id;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.id = exprs[0];
        return true;
    }

    protected Bound[] get(Event event) {
        String id = (String)this.id.getSingle(event);
        return new Bound[]{SkBee.getPlugin().getBoundConfig().getBoundFromID(id)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Bound> getReturnType() {
        return Bound.class;
    }

    public String toString(Event e, boolean d) {
        return "bound from id " + this.id.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBoundFromID.class, Bound.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"bound (of|from|with) id %string%"});
    }
}

