/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.NBT.NBTApi;
import com.shanebeestudios.skbee.api.NBT.NBTCompound;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="NBT - Set Block with NBT")
@Description(value={"Set a block at a location to a block with NBT. BlockData is also supported when using MC 1.13+ and Skript 2.5+"})
@Examples(value={"set nbt-block at player to west facing furnace with nbt \"{CustomName:\"\"{\\\"\"text\\\"\":\\\"\"&aFurnieFurnace\\\"\"}\"\"}\"", "set nbt-block at event-location to hopper with nbt \"{CustomName:\"\"{\\\"\"text\\\"\":\\\"\"&cHoppieHopper\\\"\"}\"\"}\"", "set nbt-block at player to furnace[facing=west] with nbt \"{CustomName:\"\"{\\\"\"text\\\"\":\\\"\"&aFurnieFurnace\\\"\"}\"\"}\""})
@Since(value="1.0.0")
public class EffSetBlockNBT
extends Effect {
    private static final NBTApi NBT_API;
    private static final boolean BLOCK_DATA;
    private Expression<Location> locations;
    private Expression<Object> type;
    private Expression<Object> nbtObject;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        this.type = exprs[2];
        this.locations = Direction.combine(exprs[0], exprs[1]);
        this.nbtObject = exprs[3];
        return true;
    }

    public void execute(@NotNull Event event) {
        String value;
        Object nbtObject = this.nbtObject.getSingle(event);
        String string = value = nbtObject instanceof NBTCompound ? nbtObject.toString() : (String)nbtObject;
        if (value == null) {
            return;
        }
        if (BLOCK_DATA) {
            Object typeObject = this.type.getSingle(event);
            if (typeObject == null) {
                return;
            }
            for (Location loc : (Location[])this.locations.getArray(event)) {
                if (!$assertionsDisabled && loc == null) {
                    throw new AssertionError(this.locations);
                }
                Block block = loc.getBlock();
                if (typeObject instanceof BlockData) {
                    block.setBlockData((BlockData)typeObject);
                } else {
                    ItemType itemType = (ItemType)typeObject;
                    itemType.setBlock(block, true);
                }
                NBT_API.addNBT(block, value, NBTApi.ObjectType.BLOCK);
            }
        } else {
            ItemType block = (ItemType)this.type.getSingle(event);
            if (block == null) {
                return;
            }
            for (Location loc : (Location[])this.locations.getArray(event)) {
                if (!$assertionsDisabled && loc == null) {
                    throw new AssertionError(this.locations);
                }
                block.getBlock().setBlock(loc.getBlock(), true);
                NBT_API.addNBT(loc.getBlock(), value, NBTApi.ObjectType.BLOCK);
            }
        }
    }

    @NotNull
    public String toString(Event e, boolean debug) {
        return "set block " + this.locations.toString(e, debug) + " to " + this.type.toString(e, debug) + " with nbt " + this.nbtObject.toString(e, debug);
    }

    static {
        boolean bl = $assertionsDisabled = !EffSetBlockNBT.class.desiredAssertionStatus();
        if (Skript.classExists((String)"org.bukkit.block.data.BlockData") && Skript.classExists((String)"ch.njol.skript.expressions.ExprBlockData")) {
            BLOCK_DATA = true;
            Skript.registerEffect(EffSetBlockNBT.class, (String[])new String[]{"set (nbt[(-| )]block|tile[(-| )]entity) %directions% %locations% to %itemtype/blockdata% with nbt %string/nbtcompound%"});
        } else {
            BLOCK_DATA = false;
            Skript.registerEffect(EffSetBlockNBT.class, (String[])new String[]{"set (nbt[(-| )]block|tile[(-| )]entity) %directions% %locations% to %itemtype% with nbt %string/nbtcompound%"});
        }
        NBT_API = SkBee.getPlugin().getNbtApi();
    }
}

