/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.EffSpawn;
import ch.njol.skript.entity.EntityType;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.NBT.NBTApi;
import com.shanebeestudios.skbee.api.NBT.NBTCompound;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.util.Consumer;
import org.jetbrains.annotations.NotNull;

@Name(value="NBT - Spawn Entity with NBT")
@Description(value={"Spawn an entity at a location with NBT"})
@Examples(value={"spawn sheep at player with nbt \"{NoAI:1b}\"", "spawn 1 of zombie at player with nbt \"{NoGravity:1b}\""})
@Since(value="1.0.0")
public class EffSpawnEntityNBT
extends Effect {
    private static final NBTApi NBT_API;
    private static final boolean HAS_CONSUMER;
    private Expression<Location> locations;
    private Expression<EntityType> types;
    private Expression<Object> nbt;
    @Nullable
    private Expression<Number> amount;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        this.amount = matchedPattern == 0 ? null : exprs[0];
        this.types = exprs[matchedPattern];
        this.locations = Direction.combine(exprs[1 + matchedPattern], exprs[2 + matchedPattern]);
        this.nbt = exprs[3 + matchedPattern];
        return true;
    }

    public void execute(@NotNull Event event) {
        Integer a;
        Object nbtObject = this.nbt.getSingle(event);
        String value = nbtObject instanceof NBTCompound ? nbtObject.toString() : (String)nbtObject;
        Number number = a = this.amount != null ? (Number)((Number)this.amount.getSingle(event)) : (Number)1;
        if (a == null) {
            return;
        }
        EntityType[] et = (EntityType[])this.types.getArray(event);
        for (Location loc : (Location[])this.locations.getArray(event)) {
            assert (loc != null) : this.locations;
            for (EntityType type : et) {
                int i = 0;
                while ((double)i < ((Number)a).doubleValue() * (double)type.getAmount()) {
                    EffSpawn.lastSpawned = this.spawn(loc, type.data.getType(), value);
                    ++i;
                }
            }
        }
    }

    @NotNull
    public String toString(Event e, boolean debug) {
        return "spawn " + (this.amount != null ? this.amount.toString(e, debug) + " " : "") + this.types.toString(e, debug) + " " + this.locations.toString(e, debug) + " " + this.nbt.toString(e, debug);
    }

    private <T extends Entity> Entity spawn(Location loc, Class<T> type, String nbt) {
        if (HAS_CONSUMER) {
            return loc.getWorld().spawn(loc, type, ent -> NBT_API.addNBT(ent, nbt, NBTApi.ObjectType.ENTITY));
        }
        Entity e = loc.getWorld().spawn(loc, type);
        NBT_API.addNBT(e, nbt, NBTApi.ObjectType.ENTITY);
        return e;
    }

    static {
        HAS_CONSUMER = Skript.classExists((String)"org.bukkit.util.Consumer") && Skript.methodExists(World.class, (String)"spawn", (Class[])new Class[]{Location.class, Class.class, Consumer.class});
        Skript.registerEffect(EffSpawnEntityNBT.class, (String[])new String[]{"spawn %entitytypes% [%directions% %locations%] with nbt %string/nbtcompound%", "spawn %number% of %entitytypes% [%directions% %locations%] with nbt %string/nbtcompound%"});
        NBT_API = SkBee.getPlugin().getNbtApi();
    }
}

