/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.NBT.NBTApi;
import com.shanebeestudios.skbee.api.NBT.NBTCompound;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="NBT - Item from NBT")
@Description(value={"This expression allows you to grab an item from NBT strings or compounds (compound support added in 1.6.0). ", "This can be useful when wanting to grab items from file nbt, or nbt of an entity or an inventory holding block (like a chest or furnace).", "It can also be useful for creating your own serializing system. The NBT string required for this must be an item's FULL item NBT ", "(This must include the item type and amount, example of full: \"{id:\"minecraft:iron_sword\",tag:{Damage:0},Count:1b}\"", " example of partial nbt of the same item: \"{Damage:0}\")."})
@Examples(value={"set {_i} to item from nbt \"{id:\"\"minecraft:iron_sword\"\",tag:{Damage:0},Count:1b}\"", "\n", "set {_nbt::*} to tag \"Inventory\" of file nbt of \"world/playerdata/some-players-uuid.dat\"", "loop {_nbt::*}", "\tset {_i} to item from nbt loop-value"})
@Since(value="1.4.10")
public class ExprItemFromNBT
extends PropertyExpression<Object, ItemType> {
    private static final NBTApi NBT_API;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean i, @NotNull SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected ItemType @NotNull [] get(@NotNull Event e, Object @NotNull [] source) {
        return (ItemType[])this.get(source, nbt -> {
            if (nbt instanceof String) {
                return NBT_API.getItemTypeFromNBT((String)nbt);
            }
            if (nbt instanceof NBTCompound) {
                return NBT_API.getItemTypeFromNBT((NBTCompound)nbt);
            }
            return null;
        });
    }

    @NotNull
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "Item from nbt string(s) " + this.getExpr().toString(e, d);
    }

    static {
        Skript.registerExpression(ExprItemFromNBT.class, ItemType.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"item[s] from nbt[s] %strings/nbtcompounds%", "nbt item[s] from %strings/nbtcompounds%"});
        NBT_API = SkBee.getPlugin().getNbtApi();
    }
}

