/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.Util;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="NBT - UUID for NBT")
@Description(value={"Allows you to get an entity's UUID which can be represented in an NBT compound. Prior to 1.16 UUIDs were represented ", "as most/least significant bits. As of 1.16, they are now represented as int arrays. If the player/entity is excluded, this ", "will return a random UUID."})
@Examples(value={"set {_u::*} to uuid int array of player", "set {_u} to uuid int array as string from player", "set {_m} to uuid most from target entity", "set {_l} to uuid least bits of event-entity"})
@Since(value="1.5.2")
public class ExprNBTUuid
extends SimpleExpression<Object> {
    private int pattern;
    @Nullable
    private Expression<Object> entity;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = parseResult.mark;
        this.entity = exprs[0];
        return true;
    }

    @Nullable
    protected Object[] get(@NotNull Event e) {
        UUID uuid = UUID.randomUUID();
        if (this.entity != null) {
            Object object = this.entity.getSingle(e);
            if (object == null) {
                return null;
            }
            uuid = object instanceof OfflinePlayer ? ((OfflinePlayer)object).getUniqueId() : ((Entity)object).getUniqueId();
        }
        if (this.pattern < 2) {
            int[] uuidIntArray = Util.uuidToIntArray(uuid);
            if (this.pattern == 0) {
                ArrayList<Integer> uuidList = new ArrayList<Integer>();
                for (int i : uuidIntArray) {
                    uuidList.add(i);
                }
                return uuidList.toArray(new Integer[0]);
            }
            StringBuilder builder = new StringBuilder("[I;");
            for (int i = 0; i < 4; ++i) {
                if (i != 0) {
                    builder.append(",");
                }
                builder.append(uuidIntArray[i]);
            }
            return new String[]{builder.append("]").toString()};
        }
        if (this.pattern == 2) {
            return new Long[]{uuid.getMostSignificantBits()};
        }
        return new Long[]{uuid.getLeastSignificantBits()};
    }

    public boolean isSingle() {
        return this.pattern != 0;
    }

    @NotNull
    public Class<?> getReturnType() {
        return Object.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String[] pat = new String[]{"int array", "int array as strings", "most bits", "least bit"};
        return "uuid " + pat[this.pattern] + " from " + this.entity.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprNBTUuid.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"uuid (int array[(1\u00a6 as string)]|2\u00a6most[ bits]|3\u00a6least[ bits]) [(from|of) %-offlineplayer/entity%]"});
    }
}

