/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.NBT.NBTApi;
import com.shanebeestudios.skbee.api.NBT.NBTCompound;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Name(value="NBT - Item/Inventory Slot/Entity/Block/File")
@Description(value={"NBT of items, inventory slots, entities, tile entities (such as a furnace, hopper, brewing stand, banner, etc) or files. ", "Supports get, set, add and reset. Reset will only properly work on an item, not entities or blocks. ", "Set should not be used on entities or blocks, it's best to use add. Using set can quite often screw up the entity/block's location. ", "The optional 'full' part (added in 1.4.10) will only work on items/slots. When using this, it will return the full NBT of said item, ", "including the item amount as well as the item type."})
@Examples(value={"set {_nbt} to nbt of player's tool", "set {_f} to full nbt of player's tool", "add \"{Enchantments:[{id:\"\"sharpness\"\",lvl:5}]}\" to nbt of player's tool", "reset nbt of player's tool", "set {_nbt} to nbt of target entity", "set {_nbt} to event-entity", "add \"{CustomName:\"\"{\\\"\"text\\\"\":\\\"\"&bMyNewName\\\"\"}\"\"}\" to nbt of target entity", "add \"{RequiredPlayerRange:0s}\" to targeted block's nbt", "add \"{SpawnData:{id:\"\"minecraft:wither\"\"}}\" to nbt of clicked block", "set {_nbt} to file-nbt of \"world/playerdata/some-uuid-here.dat\""})
@Since(value="1.0.0")
public class ExprObjectNBT
extends SimplePropertyExpression<Object, Object> {
    private static final NBTApi NBT_API;
    private boolean full;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.full = parseResult.mark == 1;
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    public String convert(@NotNull Object object) {
        NBTApi.ObjectType objectType = null;
        if (object instanceof Slot) {
            objectType = this.full ? NBTApi.ObjectType.SLOT_FULL : NBTApi.ObjectType.SLOT;
        } else if (object instanceof ItemStack) {
            objectType = this.full ? NBTApi.ObjectType.ITEM_STACK_FULL : NBTApi.ObjectType.ITEM_STACK;
        } else if (object instanceof ItemType) {
            objectType = this.full ? NBTApi.ObjectType.ITEM_TYPE_FULL : NBTApi.ObjectType.ITEM_TYPE;
        } else if (object instanceof Entity) {
            objectType = NBTApi.ObjectType.ENTITY;
        } else if (object instanceof Block) {
            objectType = NBTApi.ObjectType.BLOCK;
        } else if (object instanceof String) {
            objectType = NBTApi.ObjectType.FILE;
        }
        if (objectType != null) {
            return NBT_API.getNBT(object, objectType);
        }
        return null;
    }

    public Class<?>[] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object.class});
        }
        return null;
    }

    public void change(@NotNull Event event, Object[] delta, @NotNull Changer.ChangeMode mode) {
        Object object = this.getExpr().getSingle(event);
        if (object == null) {
            return;
        }
        Object nbtObject = delta != null ? delta[0] : null;
        String value = "{}";
        if (nbtObject != null) {
            String string = nbtObject instanceof NBTCompound ? nbtObject.toString() : (value = nbtObject instanceof String ? (String)nbtObject : "{}");
        }
        if (!NBTApi.validateNBT(value)) {
            return;
        }
        NBTApi.ObjectType objectType = null;
        if (object instanceof Slot) {
            objectType = NBTApi.ObjectType.SLOT;
        } else if (object instanceof ItemStack) {
            objectType = NBTApi.ObjectType.ITEM_STACK;
        } else if (object instanceof ItemType) {
            objectType = NBTApi.ObjectType.ITEM_TYPE;
        } else if (object instanceof Entity) {
            objectType = NBTApi.ObjectType.ENTITY;
        } else if (object instanceof Block) {
            objectType = NBTApi.ObjectType.BLOCK;
        } else if (object instanceof String) {
            objectType = NBTApi.ObjectType.FILE;
        }
        switch (mode) {
            case ADD: {
                if (objectType == null) break;
                NBT_API.addNBT(object, value, objectType);
                break;
            }
            case SET: 
            case RESET: {
                if (objectType == null) break;
                NBT_API.setNBT(object, value, objectType);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @NotNull
    protected String getPropertyName() {
        return "object nbt";
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        ExprObjectNBT.register(ExprObjectNBT.class, Object.class, (String)"[(1\u00a6full )][(entity|item|slot|block|tile[(-| )]entity|file)(-| )]nbt", (String)"block/entity/itemstack/itemtype/slot/string");
        NBT_API = SkBee.getPlugin().getNbtApi();
    }
}

