/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.NBT.NBTCompound;
import com.shanebeestudios.skbee.api.NBT.NBTContainer;
import com.shanebeestudios.skbee.api.reflection.ChatReflection;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="NBT - Pretty NBT String")
@Description(value={"Get a 'pretty' NBT string. This is colored the same as when using the vanilla Minecraft '/data' command. ", "Splitting it will output kind of like a JSON output. Requires 1.13.2+"})
@Examples(value={"set {_p} to pretty nbt from nbt compound of player's tool", "send pretty nbt from {_nbt} to player", "send pretty nbt from {_nbt} with split \" \" to console"})
@Since(value="1.6.0")
public class ExprPrettyNBT
extends PropertyExpression<Object, String> {
    private Expression<String> split;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.split = exprs[1];
        return true;
    }

    protected String @NotNull [] get(@NotNull Event e, Object @NotNull [] source) {
        return (String[])this.get(source, n -> {
            NBTCompound compound;
            String split;
            String string = split = this.split != null ? (String)this.split.getSingle(e) : null;
            if (n instanceof NBTCompound) {
                compound = (NBTCompound)n;
            } else if (n instanceof String) {
                compound = new NBTContainer((String)n);
            } else {
                return null;
            }
            return ChatReflection.getPrettyNBT(compound, split);
        });
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "pretty nbt from " + this.getExpr().toString(e, d) + (this.split != null ? " with split " + this.split.toString(e, d) : "");
    }

    static {
        Skript.registerExpression(ExprPrettyNBT.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"pretty nbt (of|from) %nbtcompounds/strings% [(with|using) split %-string%]", "%nbtcompounds/strings%'[s] pretty nbt [(with|using) split %-string%]"});
    }
}

