/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.types;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.yggdrasil.Fields;
import com.shanebeestudios.skbee.api.NBT.NBTCompound;
import com.shanebeestudios.skbee.api.NBT.NBTContainer;
import com.shanebeestudios.skbee.api.NBT.NBTCustomType;
import java.io.StreamCorruptedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkriptTypes {
    static {
        Classes.registerClass((ClassInfo)new ClassInfo(NBTCustomType.class, "nbttype").user(new String[]{"nbt ?types?"}).name("NBT - Tag Type").description(new String[]{"Represents a type of NBT tag."}).usage(new String[]{NBTCustomType.getNames()}).examples(new String[]{"set byte tag \"points\" of {_nbt} to 1", "set compound tag \"tool\" of {_nbt} to nbt compound of player's tool"}).since("1.10.0").parser((Parser)new Parser<NBTCustomType>(){

            @Nullable
            public NBTCustomType parse(String s, ParseContext context) {
                return NBTCustomType.fromName(s);
            }

            public String toString(NBTCustomType nbtCustomType, int i) {
                return nbtCustomType.getName();
            }

            public String toVariableNameString(NBTCustomType nbtCustomType) {
                return this.toString(nbtCustomType, 0);
            }

            public String getVariableNamePattern() {
                return "\\S";
            }
        }));
        Classes.registerClass((ClassInfo)new ClassInfo(NBTCompound.class, "nbtcompound").user(new String[]{"nbt ?compound"}).name("NBT - Compound").description(new String[]{"Represents the NBT compound of an entity/block/item."}).usage(new String[]{"{id:\"minecraft:netherite_axe\",tag:{Damage:0,Enchantments:[{id:\"minecraft:unbreaking\",lvl:2s}]},Count:1b}"}).examples(new String[]{"set {_a} to nbt compound of player"}).since("1.6.0").parser((Parser)new Parser<NBTCompound>(){

            public boolean canParse(@NotNull ParseContext context) {
                return false;
            }

            public String toString(@NotNull NBTCompound nbt, int flags) {
                return nbt.toString();
            }

            public String toVariableNameString(@NotNull NBTCompound nbt) {
                return "nbt:" + nbt.toString();
            }

            public String getVariableNamePattern() {
                return "nbt:.+";
            }
        }).serializer((Serializer)new Serializer<NBTCompound>(){

            @NotNull
            public Fields serialize(@NotNull NBTCompound nbt) {
                Fields fields = new Fields();
                fields.putObject("nbt", (Object)nbt.toString());
                return fields;
            }

            public void deserialize(@NotNull NBTCompound o, @NotNull Fields f) {
                assert (false);
            }

            protected NBTCompound deserialize(@NotNull Fields fields) throws StreamCorruptedException {
                String nbt = (String)fields.getObject("nbt", String.class);
                assert (nbt != null);
                try {
                    return new NBTContainer(nbt);
                }
                catch (IllegalArgumentException ex) {
                    throw new StreamCorruptedException("Invalid nbt data: " + nbt);
                }
            }

            public boolean mustSyncDeserialization() {
                return true;
            }

            protected boolean canBeInstantiated() {
                return false;
            }
        }));
    }
}

