/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Bone Meal Effect")
@Description(value={"Apply the bone meal effect to a block. Requires Minecraft 1.16.2+"})
@Examples(value={"apply bonemeal effect to target block of player"})
@Since(value="1.7.0")
public class EffBonemeal
extends Effect {
    private Expression<Block> blocks;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.blocks = exprs[0];
        return true;
    }

    protected void execute(Event e) {
        for (Block block : (Block[])this.blocks.getArray(e)) {
            block.applyBoneMeal(BlockFace.UP);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "apply bonemeal effect to " + this.blocks.toString(e, d);
    }

    static {
        if (Skript.methodExists(Block.class, (String)"applyBoneMeal", (Class[])new Class[]{BlockFace.class})) {
            Skript.registerEffect(EffBonemeal.class, (String[])new String[]{"apply bone[ ]meal [effect] to %blocks%"});
        }
    }
}

