/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import java.util.List;
import org.bukkit.block.Beehive;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.EntityBlockStorage;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="EntityBlockStorage - Add/Release entities")
@Description(value={"Add/release entities to/from blocks which can store entities.", "When releasing bees at night/during rain, they will immediately go back in their hive, use the optional timespan to keep them outside.", "You can optionally put the released entities into a variable (see examples).", "As of 1.15 this only includes beehives/bee nests! Requires Spigot/Paper 1.15.2+"})
@Examples(value={"add last spawned bee to storage of target block of player", "release all entities from storage of target block of player", "release all entities from storage of event-block for 2 minutes", "release all entities from storage of target block of player for 1 minute into {_bees::*}"})
@Since(value="1.0.0")
public class EffEntityBlockStorage
extends Effect {
    private Expression<Entity> entities;
    private Expression<Block> blocks;
    private Expression<Timespan> timespan;
    private Expression<?> var;
    private boolean release;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.entities = i == 0 ? null : exprs[0];
        this.blocks = exprs[i];
        this.release = i == 0;
        this.timespan = this.release ? exprs[1] : null;
        this.var = this.release ? exprs[2] : null;
        return true;
    }

    protected void execute(Event event) {
        if (this.release) {
            if (this.blocks == null) {
                return;
            }
            long ticks = this.timespan != null ? ((Timespan)this.timespan.getSingle(event)).getTicks_i() : 0L;
            for (Block block : (Block[])this.blocks.getArray(event)) {
                BlockState state = block.getState();
                if (!(state instanceof EntityBlockStorage)) continue;
                List entities = ((EntityBlockStorage)state).releaseEntities();
                for (Entity entity : entities) {
                    if (!(entity instanceof Bee) || ticks <= 0L) continue;
                    ((Bee)entity).setCannotEnterHiveTicks((int)ticks);
                }
                if (this.var == null) continue;
                this.var.change(event, entities.toArray(), Changer.ChangeMode.SET);
            }
        } else {
            if (this.blocks == null || this.entities == null) {
                return;
            }
            BlockState state = ((Block)this.blocks.getSingle(event)).getState();
            for (Entity entity : (Entity[])this.entities.getArray(event)) {
                if (!(state instanceof Beehive) || !(entity instanceof Bee)) continue;
                ((Beehive)state).addEntity((Entity)((Bee)entity));
                state.update();
            }
        }
    }

    public String toString(Event e, boolean d) {
        String time = this.timespan != null ? " for " + this.timespan.toString(e, d) : "";
        String var = this.var != null ? " into " + this.var.toString(e, d) : "";
        return this.release ? "Release all entities from " + this.blocks.toString(e, d) + time + var : "Add " + this.entities.toString(e, d) + " to storage of " + this.blocks.toString(e, d);
    }

    static {
        if (Skript.classExists((String)"org.bukkit.block.EntityBlockStorage")) {
            Skript.registerEffect(EffEntityBlockStorage.class, (String[])new String[]{"release [all] entities from [storage of] %blocks% [for %-timespan%] [into %-objects%]", "add %entities% to [storage of] %block%"});
        }
    }
}

