/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Open Sign")
@Description(value={"Open a sign's GUI to a player, to allow them to edit it. Requires Paper (not sure which version, but at least 1.12.x)"})
@Examples(value={"open sign gui of target block to player", "open target block's sign gui to player"})
public class EffOpenSign
extends Effect {
    private Expression<Location> locations;
    private Expression<Player> player;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.locations = Direction.combine(exprs[0], exprs[1]);
        this.player = exprs[2];
        return true;
    }

    protected void execute(@NotNull Event e) {
        Location location = (Location)this.locations.getSingle(e);
        Player player = (Player)this.player.getSingle(e);
        if (location == null || player == null) {
            return;
        }
        BlockState block = location.getBlock().getState();
        if (block instanceof Sign) {
            player.openSign((Sign)block);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "open sign for " + this.locations.toString(e, d) + " to " + this.player.toString(e, d);
    }

    static {
        if (Skript.methodExists(HumanEntity.class, (String)"openSign", (Class[])new Class[]{Sign.class})) {
            Skript.registerEffect(EffOpenSign.class, (String[])new String[]{"open sign [gui] [(for|of)] [%direction%] %location% to %player%", "open [%direction%] %location%'[s] sign [gui] to %player%"});
        }
    }
}

