/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.slot.Slot;
import com.shanebeestudios.skbee.api.event.EntityBlockInteractEvent;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class OtherEvents {
    static {
        Skript.registerEvent((String)"Block Physical Interact Event", SimpleEvent.class, EntityBlockInteractEvent.class, (String[])new String[]{"block (interact|trample)"}).description(new String[]{"Called when an entity physically interacts with a block, for example, trampling."}).examples(new String[]{"on block interact:", "\tif event-entity is a villager:", "\t\tcancel event"}).since("1.5.0");
        EventValues.registerEventValue(EntityBlockInteractEvent.class, Block.class, (Getter)new Getter<Block, EntityBlockInteractEvent>(){

            @Nullable
            public Block get(EntityBlockInteractEvent event) {
                return event.getBlock();
            }
        }, (int)0);
        Skript.registerEvent((String)"Anvil Prepare Event", SimpleEvent.class, PrepareAnvilEvent.class, (String[])new String[]{"anvil prepare"}).description(new String[]{"Called when a player attempts to combine 2 items in an anvil.", "'event-slot' represents the result slot, can be used to get or set."}).examples(new String[]{"on anvil prepare:", "\tif slot 0 of event-inventory is a diamond sword:", "\t\tif slot 1 of event-inventory is an enchanted book:", "\t\t\tif stored enchants of slot 1 of event-inventory contains sharpness 5:", "\t\t\t\tset {_i} to slot 0 of event-inventory", "\t\t\t\tadd \"&aOOOOOOO\" and \"&bAHHHHHH\" to lore of {_i}", "\t\t\t\tenchant {_i} with sharpness 6", "\t\t\t\tset event-slot to {_i}", "\t\t\t\tset repair cost of event-inventory to 30"}).since("1.11.0");
        EventValues.registerEventValue(PrepareAnvilEvent.class, Player.class, (Getter)new Getter<Player, PrepareAnvilEvent>(){

            @Nullable
            public Player get(PrepareAnvilEvent event) {
                return (Player)event.getViewers().get(0);
            }
        }, (int)0);
        EventValues.registerEventValue(PrepareAnvilEvent.class, Slot.class, (Getter)new Getter<Slot, PrepareAnvilEvent>(){

            @Nullable
            public Slot get(final PrepareAnvilEvent event) {
                return new Slot(){

                    @Nullable
                    public ItemStack getItem() {
                        return event.getResult();
                    }

                    public void setItem(@Nullable ItemStack item) {
                        event.setResult(item);
                    }

                    public int getAmount() {
                        return event.getResult().getAmount();
                    }

                    public void setAmount(int amount) {
                        event.getResult().setAmount(amount);
                    }

                    public boolean isSameSlot(Slot o) {
                        ItemStack item = o.getItem();
                        return item != null && item.isSimilar(event.getResult());
                    }

                    public String toString(@Nullable Event e, boolean debug) {
                        return "anvil inventory result slot";
                    }
                };
            }
        }, (int)0);
        EventValues.registerEventValue(PrepareAnvilEvent.class, Inventory.class, (Getter)new Getter<Inventory, PrepareAnvilEvent>(){

            @Nullable
            public Inventory get(PrepareAnvilEvent event) {
                return event.getInventory();
            }
        }, (int)0);
    }
}

