/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import com.destroystokyo.paper.event.entity.EntityKnockbackByEntityEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Knockback Attacker/Victim")
@Description(value={"The attacker/victim in an entity knockback event. Paper 1.12.2+"})
@Examples(value={"on entity knockback:", "\tif knockback attacker is a player:", "\t\tif knockback victim is a sheep:", "\t\t\tcancel event"})
@Since(value="1.8.0")
public class ExprKnockbackAttackerVictim
extends SimpleExpression<Entity> {
    private Integer ent;

    public boolean init(Expression<?> @NotNull [] expressions, int i, @NotNull Kleenean kleenean, @NotNull SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent(EntityKnockbackByEntityEvent.class)) {
            Skript.error((String)"Can not use 'knockback attacker/victim' outside of knockback event", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.ent = parseResult.mark;
        return true;
    }

    protected Entity[] get(@NotNull Event e) {
        if (this.ent == 1) {
            return new Entity[]{ExprKnockbackAttackerVictim.getVictim(e)};
        }
        return new Entity[]{ExprKnockbackAttackerVictim.getAttacker(e)};
    }

    @NotNull
    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    @Nullable
    private static Entity getAttacker(@Nullable Event e) {
        if (e instanceof EntityKnockbackByEntityEvent) {
            return ((EntityKnockbackByEntityEvent)e).getHitBy();
        }
        return null;
    }

    @Nullable
    private static Entity getVictim(@Nullable Event e) {
        if (e instanceof EntityKnockbackByEntityEvent) {
            return ((EntityKnockbackByEntityEvent)e).getEntity();
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public String toString(Event event, boolean b) {
        return String.format("knockback %s", this.ent == 1 ? "victim" : "attacker");
    }

    static {
        Skript.registerExpression(ExprKnockbackAttackerVictim.class, Entity.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] knockback (0\u00a6attacker|1\u00a6victim)"});
    }
}

