/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Getter;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.PlayerUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Total Experience")
@Description(value={"Represents the total experience points the player currently has."})
@Examples(value={"add 10 to total experience of player", "remove 100 from total experience of player", "set total xp of player to 1500", "set {_t} to total experience of player"})
@Since(value="1.2.0")
public class ExprTotalXP
extends PropertyExpression<Player, Integer> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected Integer[] get(Event e, Player[] source) {
        return (Integer[])this.get(source, (Converter)new Getter<Integer, Player>(){

            @Nullable
            public Integer get(Player player) {
                return PlayerUtils.getTotalXP(player);
            }
        });
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int change = delta == null ? 0 : ((Number)delta[0]).intValue();
        for (Player player : (Player[])this.getExpr().getArray(e)) {
            int value = PlayerUtils.getTotalXP(player);
            switch (mode) {
                case ADD: {
                    value += change;
                    break;
                }
                case REMOVE: {
                    value -= change;
                    break;
                }
                case SET: {
                    value = change;
                }
            }
            PlayerUtils.setTotalXP(player, value);
        }
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "total experience points of " + this.getExpr().toString(e, d);
    }

    static {
        ExprTotalXP.register(ExprTotalXP.class, Integer.class, (String)"total (xp|experience) [points]", (String)"players");
    }
}

