/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.elements.recipe.util.RecipeUtil;
import javax.annotation.Nullable;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Recipe - Has Discovered")
@Description(value={"Check if a player has discovered a recipe. Can check recipes you created, another plugin has created, or vanilla Minecraft recipes.When checking recipes that are not your own, make sure to include the namespace, ex \"minecraft:diamond_sword\", \"someplugin:some_recipe\". This condition is only available on 1.16+"})
@Examples(value={"player has discovered recipe \"minecraft:furnace\"", "if player has discovered recipe \"my_custom_sword\":", "if player has discovered recipe \"someplugin:fancy_shovel\":", "if all players have not discovered recipe \"minecraft:golden_shovel\":", "if player has not discovered recipe \"my_fancy_hoe\":"})
@Since(value="1.4.9")
public class CondHasDiscoveredRecipe
extends Condition {
    private Expression<Player> players;
    private Expression<String> recipes;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.recipes = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event e) {
        return this.players.check(e, player -> this.recipes.check(e, recipe -> player.hasDiscoveredRecipe(RecipeUtil.getKeyFromString(recipe))), this.isNegated());
    }

    public String toString(@Nullable Event e, boolean d) {
        return this.players.toString(e, d) + (this.players.isSingle() ? " has" : " have") + (this.isNegated() ? " not" : "") + " discovered recipe(s) " + this.recipes.toString(e, d);
    }

    static {
        if (Skript.methodExists(HumanEntity.class, (String)"hasDiscoveredRecipe", (Class[])new Class[]{NamespacedKey.class})) {
            Skript.registerCondition(CondHasDiscoveredRecipe.class, (String[])new String[]{"%players% (has|have) discovered recipe[s] %strings%", "%players% (has|have) not discovered recipe[s] %strings%"});
        }
    }
}

