/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Is Minecraft Tagged")
@Description(value={"Check if an item is tagged with a Minecraft tag."})
@Examples(value={"if player's tool is tagged with minecraft tag \"carpets\":", "if target block is not tagged as minecraft tag \"fence_gates\"", "if clicked block is tagged as minecraft block tag \"doors\" or minecraft block tag \"fence_gates\""})
@Since(value="1.10.0")
public class CondIsMinecraftTagged
extends Condition {
    private Expression<ItemType> itemTypes;
    private Expression<Tag> tags;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.itemTypes = exprs[0];
        this.tags = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event event) {
        return this.itemTypes.check(event, item -> {
            Material material = item.getMaterial();
            return this.tags.check(event, tag -> tag.isTagged((Keyed)material));
        }, this.isNegated());
    }

    public String toString(@Nullable Event e, boolean d) {
        return this.itemTypes.toString(e, d) + " is tagged with " + this.tags.toString(e, d);
    }

    static {
        if (Skript.isRunningMinecraft((int)1, (int)13)) {
            PropertyCondition.register(CondIsMinecraftTagged.class, (String)"tagged (with|as) %minecrafttags%", (String)"itemtypes");
        }
    }
}

