/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.config.Config;
import com.shanebeestudios.skbee.elements.recipe.util.RecipeUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.SmokingRecipe;

@Name(value="Recipe - Cooking")
@Description(value={"Register new cooking recipes. On 1.13+ you can register recipes for furnaces. ", "On 1.14+ you can also register recipes for smokers, blast furnaces and campfires. ", "The ID will be the name given to this recipe. IDs may only contain letters, numbers, periods, hyphens and underscores. Used for recipe discovery/unlocking recipes for players. You may also include an optional group for recipes. These will group the recipes together in the recipe book.", "By default recipes will start with the namespace \"skrecipe:\", this can be changed in the config to whatever you want."})
@Examples(value={"on skript load:", "\tregister new furnace recipe for diamond using dirt with id \"furnace_diamond\"", "\tregister new blasting recipe for emerald using dirt with id \"blasting_emerald\"", "\tregister new smoking recipe for cooked cod named \"Hot Cod\" using puffer fish with id \"smoking_cod\""})
@RequiredPlugins(value={"1.13+ for furnaces. 1.14+ for smokers, blast furnaces and campfires."})
@Since(value="1.0.0")
public class EffCookingRecipe
extends Effect {
    private final Config config = SkBee.getPlugin().getPluginConfig();
    private Expression<ItemType> item;
    private Expression<Object> ingredient;
    private Expression<String> key;
    private Expression<Number> experience;
    private Expression<Timespan> cookTime;
    private Expression<String> group;
    private int recipeType;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.item = exprs[0];
        this.ingredient = exprs[1];
        this.key = exprs[2];
        this.experience = exprs[3];
        this.cookTime = exprs[4];
        this.group = exprs[5];
        this.recipeType = parseResult.mark;
        return true;
    }

    protected void execute(Event event) {
        Object ingredient;
        ItemType res = (ItemType)this.item.getSingle(event);
        Object ing = this.ingredient.getSingle(event);
        if (res == null) {
            Skript.error((String)"Error registering cooking recipe - result is null");
            Skript.error((String)("Current Item: \u00a76" + this.toString(event, true)));
            return;
        }
        if (ing == null) {
            Skript.error((String)"Error registering cooking recipe - ingredient is null");
            Skript.error((String)("Current Item: \u00a76" + this.toString(event, true)));
            return;
        }
        ItemStack result = res.getRandom();
        if (ing instanceof ItemType) {
            Material material;
            ItemStack itemStack = ((ItemType)ing).getRandom();
            ingredient = itemStack.isSimilar(new ItemStack(material = itemStack.getType())) ? new RecipeChoice.MaterialChoice(material) : new RecipeChoice.ExactChoice(itemStack);
        } else if (ing instanceof RecipeChoice.MaterialChoice) {
            ingredient = (RecipeChoice.MaterialChoice)ing;
        } else {
            return;
        }
        String group = this.group != null ? (String)this.group.getSingle(event) : "";
        NamespacedKey key = RecipeUtil.getKey((String)this.key.getSingle(event));
        float xp = this.experience != null ? ((Number)this.experience.getSingle(event)).floatValue() : 0.0f;
        int cookTime = this.cookTime != null ? (int)((Timespan)this.cookTime.getSingle(event)).getTicks_i() : this.getDefaultCookTime(this.recipeType);
        RecipeUtil.removeRecipeByKey(key);
        this.cookingRecipe(result, (RecipeChoice)ingredient, group, key, xp, cookTime);
    }

    private void cookingRecipe(ItemStack result, RecipeChoice ingredient, String group, NamespacedKey key, float xp, int cookTime) {
        BlastingRecipe recipe;
        switch (this.recipeType) {
            case 1: {
                recipe = new BlastingRecipe(key, result, ingredient, xp, cookTime);
                break;
            }
            case 2: {
                recipe = new SmokingRecipe(key, result, ingredient, xp, cookTime);
                break;
            }
            case 3: {
                recipe = new CampfireRecipe(key, result, ingredient, xp, cookTime);
                break;
            }
            default: {
                recipe = new FurnaceRecipe(key, result, ingredient, xp, cookTime);
            }
        }
        recipe.setGroup(group);
        Bukkit.addRecipe((Recipe)recipe);
        if (this.config.SETTINGS_DEBUG) {
            RecipeUtil.logCookingRecipe(recipe);
        }
    }

    private int getDefaultCookTime(int t) {
        switch (t) {
            case 1: 
            case 2: {
                return 100;
            }
            case 3: {
                return 600;
            }
        }
        return 200;
    }

    public String toString(Event e, boolean d) {
        String type;
        switch (this.recipeType) {
            case 1: {
                type = "blasting";
                break;
            }
            case 2: {
                type = "smoking";
                break;
            }
            case 3: {
                type = "campfire";
                break;
            }
            default: {
                type = "furnace";
            }
        }
        String xp = this.experience != null ? " and with xp " + this.experience.toString(e, d) : "";
        String cook = this.cookTime != null ? " and with cooktime " + this.cookTime.toString(e, d) : "";
        return "register new " + type + " recipe for " + this.item.toString(e, d) + " using " + this.ingredient.toString(e, d) + " with id " + this.key.toString(e, d) + xp + cook;
    }

    static {
        Skript.registerEffect(EffCookingRecipe.class, (String[])new String[]{"register [new] (0\u00a6furnace|1\u00a6(blast furnace|blasting)|2\u00a6smok(er|ing)|3\u00a6campfire) recipe for %itemtype% (using|with ingredient) %itemtype/materialchoice% with id %string% [[and ]with exp[erience] %-number%] [[and ]with cook[ ]time %-timespan%] [in group %-string%]"});
    }
}

