/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.config.Config;
import com.shanebeestudios.skbee.elements.recipe.util.RecipeUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.StonecuttingRecipe;

@Name(value="Recipe - StoneCutting")
@Description(value={"Register a new stone cutting recipe. The ID will be the name given to this recipe. IDs may only contain letters, numbers, periods, hyphens and underscores.", "Used for recipe discovery/unlocking recipes for players. ", "You may also include an optional group for recipes. These will group the recipes together in the recipe book.", "By default recipes will start with the namespace \"skrecipe:\", this can be changed in the config to whatever you want.", "Requires MC 1.13+"})
@Examples(value={"on skript load:", "\tregister new stone cutting recipe for diamond using diamond ore with id \"cutting_diamond\""})
@RequiredPlugins(value={"1.14+"})
@Since(value="1.0.0")
public class EffStonecuttingRecipe
extends Effect {
    private final Config config = SkBee.getPlugin().getPluginConfig();
    private Expression<ItemType> item;
    private Expression<Object> ingredient;
    private Expression<String> key;
    private Expression<String> group;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.item = exprs[0];
        this.ingredient = exprs[1];
        this.key = exprs[2];
        this.group = exprs[3];
        return true;
    }

    protected void execute(Event event) {
        Object choice;
        ItemType item = (ItemType)this.item.getSingle(event);
        Object ingredient = this.ingredient.getSingle(event);
        if (item == null) {
            Skript.error((String)"Error registering stonecutting recipe - result is null");
            Skript.error((String)("Current Item: \u00a76" + this.toString(event, true)));
            return;
        }
        if (ingredient == null) {
            Skript.error((String)"Error registering stonecutting recipe - ingredient is null");
            Skript.error((String)("Current Item: \u00a76" + this.toString(event, true)));
            return;
        }
        String group = this.group != null ? (String)this.group.getSingle(event) : "";
        NamespacedKey key = RecipeUtil.getKey((String)this.key.getSingle(event));
        if (ingredient instanceof ItemType) {
            ItemStack itemStack = ((ItemType)ingredient).getRandom();
            if (itemStack == null) {
                return;
            }
            Material material = itemStack.getType();
            choice = itemStack.isSimilar(new ItemStack(material)) ? new RecipeChoice.MaterialChoice(material) : new RecipeChoice.ExactChoice(itemStack);
        } else {
            choice = (RecipeChoice.MaterialChoice)ingredient;
        }
        StonecuttingRecipe recipe = new StonecuttingRecipe(key, item.getRandom(), (RecipeChoice)choice);
        recipe.setGroup(group);
        RecipeUtil.removeRecipeByKey(key);
        Bukkit.addRecipe((Recipe)recipe);
        if (this.config.SETTINGS_DEBUG) {
            RecipeUtil.logRecipe((Recipe)recipe, recipe.getInputChoice());
        }
    }

    public String toString(Event e, boolean d) {
        String group = this.group != null ? " in group " + this.group.toString(e, d) : "";
        return "register new stone cutting recipe for " + this.item.toString(e, d) + " using " + this.ingredient.toString(e, d) + group;
    }

    static {
        if (Skript.isRunningMinecraft((int)1, (int)14)) {
            Skript.registerEffect(EffStonecuttingRecipe.class, (String[])new String[]{"register [new] stone[ ]cutt(ing|er) recipe for %itemtype% (using|with ingredient) %itemtype/materialchoice% with id %string% [in group %-string%]"});
        }
    }
}

