/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Recipe - All Recipes")
@Description(value={"Get a list of all recipes. May be from a specific item, may be just Minecraft recipes or custom recipes.", "Due to some items having more than 1 recipe this may return multiple recipes. Requires 1.13+"})
@Examples(value={"set {_recipes::*} to all recipes of iron ingot"})
@Since(value="1.4.0")
public class ExprAllRecipes
extends SimpleExpression<String> {
    private int pattern;
    private Expression<ItemType> items;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = parseResult.mark;
        this.items = exprs[0];
        return true;
    }

    @Nullable
    protected String[] get(Event e) {
        if (this.items != null) {
            return this.getRecipesForItems((ItemType[])this.items.getAll(e));
        }
        return this.getAllRecipes();
    }

    private String[] getAllRecipes() {
        ArrayList recipes = new ArrayList();
        Bukkit.recipeIterator().forEachRemaining(recipe -> {
            if (recipe instanceof Keyed) {
                NamespacedKey key = ((Keyed)recipe).getKey();
                if (this.pattern == 0 || this.isMinecraft(key) || this.isCustom(key)) {
                    recipes.add(key.toString());
                }
            }
        });
        return recipes.toArray(new String[0]);
    }

    private String[] getRecipesForItems(ItemType[] itemTypes) {
        ArrayList<String> recipes = new ArrayList<String>();
        for (ItemType itemType : itemTypes) {
            ItemStack itemStack = itemType.getRandom();
            if (!$assertionsDisabled && itemStack == null) {
                throw new AssertionError();
            }
            for (Recipe recipe : Bukkit.getRecipesFor((ItemStack)itemStack)) {
                if (!(recipe instanceof Keyed)) continue;
                NamespacedKey key = ((Keyed)recipe).getKey();
                if (this.pattern != 0 && !this.isMinecraft(key) && !this.isCustom(key)) continue;
                recipes.add(key.toString());
            }
        }
        return recipes.toArray(new String[0]);
    }

    private boolean isMinecraft(NamespacedKey key) {
        return this.pattern == 1 && key.getNamespace().equalsIgnoreCase("minecraft");
    }

    private boolean isCustom(NamespacedKey key) {
        return this.pattern == 2 && !key.getNamespace().equalsIgnoreCase("minecraft");
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "recipes of " + this.items.toString(e, d);
    }

    static {
        boolean bl = $assertionsDisabled = !ExprAllRecipes.class.desiredAssertionStatus();
        if (Skript.classExists((String)"org.bukkit.Keyed")) {
            Skript.registerExpression(ExprAllRecipes.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[(all [[of] the]|the)] [(1\u00a6(mc|minecraft)|2\u00a6custom)] recipe[s] [(for|of) %-itemtypes%]"});
        }
    }
}

