/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.event.Event;
import org.bukkit.inventory.RecipeChoice;
import org.jetbrains.annotations.Nullable;

@Name(value="Material Choice")
@Description(value={"A material choice is a list of items or a minecraft tag, that can be used as an option in some recipes.", "When using the 'every' item type, this will grab all relatable items in a list, ie: 'every sword'.", "This allows you to have one specific slot of a recipe to accept multiple items, without having to create multiple recipes.", "Do note that material choices do not accept custom items (ie: items with names, lore, enchants, etc). Requires Minecraft 1.13+"})
@Examples(value={"set {_a} to material choice of diamond sword, diamond shovel and diamond hoe", "set {_a} to material choice of every sword", "set {_a} to material choice of minecraft tag \"doors\""})
@Since(value="1.10.0")
public class ExprMaterialChoice
extends SimpleExpression<RecipeChoice.MaterialChoice> {
    private int pattern;
    private Expression<ItemType> itemTypes;
    private Expression<Tag> tags;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        if (this.pattern == 0) {
            this.itemTypes = exprs[0];
        } else if (this.pattern == 1) {
            this.tags = exprs[0];
        }
        return true;
    }

    @Nullable
    protected RecipeChoice.MaterialChoice[] get(Event event) {
        Tag tag;
        if (this.pattern == 0) {
            ArrayList materials = new ArrayList();
            for (ItemType type : (ItemType[])this.itemTypes.getArray(event)) {
                type.getAll().forEach(itemStack -> {
                    Material material = itemStack.getType();
                    if (!materials.contains(material)) {
                        materials.add(material);
                    }
                });
            }
            return new RecipeChoice.MaterialChoice[]{new RecipeChoice.MaterialChoice(materials)};
        }
        if (this.pattern == 1 && (tag = (Tag)this.tags.getSingle(event)) != null) {
            return new RecipeChoice.MaterialChoice[]{new RecipeChoice.MaterialChoice(tag)};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends RecipeChoice.MaterialChoice> getReturnType() {
        return RecipeChoice.MaterialChoice.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        return String.format("material choice of %s", this.pattern == 0 ? this.itemTypes.toString(e, d) : this.tags.toString(e, d));
    }

    static {
        if (Skript.isRunningMinecraft((int)1, (int)13)) {
            Skript.registerExpression(ExprMaterialChoice.class, RecipeChoice.MaterialChoice.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"material choice of %itemtypes%", "material choice of %minecrafttag%"});
        }
    }
}

