/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Minecraft Tag")
@Description(value={"Represents a Minecraft tag. This includes all vanilla item/block tags registered to the server.", "Bukkit provides 2 lists, item tags and block tags. Some tags might be in both lists but still have the same effect.", "If you are unsure of all tag options, just return a list of all tags to see what is available.", "You can also get a list of all itemtypes that are tagged by a tag.", "The 'minecraft:' namespace is optional. Requires Minecraft 1.13+"})
@Examples(value={"set {_i} to minecraft tag \"doors\"", "set {_tag} to minecraft tag \"trapdoors\"", "set {_tags::*} to minecraft tags \"wall_signs\" and \"wooden_doors\"", "set {_tag} to \"minecraft:climbable\"", "", "loop minecraft tags:", "\tsend \"-%loop-value%\" to console"})
@Since(value="1.10.0")
public class ExprMinecraftTag
extends SimpleExpression<Object> {
    private static final String[] TAG_TYPE = new String[]{"items", "blocks"};
    private int pattern;
    private Expression<String> strings;
    private int tagPattern;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        if (this.pattern != 1) {
            this.strings = exprs[0];
        }
        this.tagPattern = parseResult.mark;
        return true;
    }

    @Nullable
    protected Object[] get(Event event) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (this.pattern == 1) {
            Bukkit.getTags((String)TAG_TYPE[this.tagPattern], Material.class).forEach(tags::add);
        } else {
            for (String s : (String[])this.strings.getArray(event)) {
                NamespacedKey key = NamespacedKey.minecraft((String)s.replace("minecraft:", "").toLowerCase(Locale.ROOT));
                Tag tag2 = Bukkit.getTag((String)TAG_TYPE[this.tagPattern], (NamespacedKey)key, Material.class);
                if (tag2 == null) continue;
                tags.add(tag2);
            }
            if (this.pattern == 2) {
                ArrayList items = new ArrayList();
                tags.forEach(tag -> tag.getValues().forEach(value -> {
                    if (value instanceof Material) {
                        items.add(new ItemType((Material)value));
                    }
                }));
                return items.toArray(new ItemType[0]);
            }
        }
        return tags.toArray(new Tag[0]);
    }

    public boolean isSingle() {
        if (this.pattern > 0) {
            return false;
        }
        return this.strings.isSingle();
    }

    public Class<? extends Object> getReturnType() {
        return this.pattern == 2 ? ItemType.class : Tag.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        switch (this.pattern) {
            case 0: {
                return String.format("minecraft %s tag[s] %s", TAG_TYPE[this.tagPattern], this.strings.toString(e, d));
            }
            case 1: {
                return String.format("all minecraft %s tag[s]", TAG_TYPE[this.tagPattern]);
            }
            case 2: {
                return String.format("all itemtypes of minecraft %s tag[s] %s", TAG_TYPE[this.tagPattern], this.strings.toString(e, d));
            }
        }
        return null;
    }

    static {
        if (Skript.isRunningMinecraft((int)1, (int)13)) {
            Skript.registerExpression(ExprMinecraftTag.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"minecraft [(0\u00a6item|1\u00a6block)] tag[s] %strings%", "[all] minecraft [(0\u00a6item|1\u00a6block)] tags", "[all] item[type]s of minecraft [(0\u00a6item|1\u00a6block)] tag[s] %strings%"});
        }
    }
}

