/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.type;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import org.bukkit.Tag;
import org.bukkit.inventory.RecipeChoice;
import org.jetbrains.annotations.NotNull;

public class Types {
    private static String matChoiceToString(RecipeChoice.MaterialChoice materialChoice) {
        ArrayList itemTypes = new ArrayList();
        materialChoice.getChoices().forEach(material -> itemTypes.add(new ItemType(material).toString()));
        return String.format("MaterialChoice{choices=[%s]}", StringUtils.join(itemTypes, (String)", "));
    }

    static {
        if (Skript.isRunningMinecraft((int)1, (int)13)) {
            Classes.registerClass((ClassInfo)new ClassInfo(RecipeChoice.MaterialChoice.class, "materialchoice").name("Material Choice").user(new String[]{"material choices?"}).description(new String[]{"Represents a set of materials/minecraft tags which can be used in some recipes. ", "Requires Minecraft 1.13+"}).usage(new String[]{"see material choice expression"}).examples(new String[]{"set {_a} to material choice of diamond sword, diamond shovel and diamond hoe", "set {_a} to material choice of every sword", "set {_a} to material choice of minecraft tag \"doors\""}).since("1.10.0").parser((Parser)new Parser<RecipeChoice.MaterialChoice>(){

                public boolean canParse(ParseContext context) {
                    return false;
                }

                @NotNull
                public String toString(@NotNull RecipeChoice.MaterialChoice matChoice, int flags) {
                    return Types.matChoiceToString(matChoice);
                }

                public String toVariableNameString(RecipeChoice.MaterialChoice matChoice) {
                    return "materialchoice:" + this.toString(matChoice, 0);
                }

                public String getVariableNamePattern() {
                    return "materialchoice://s";
                }
            }));
            Classes.registerClass((ClassInfo)new ClassInfo(Tag.class, "minecrafttag").name("Minecraft Tag").user(new String[]{"(minecraft )?tags?"}).description(new String[]{"Represents a tag provided by Minecraft. Requires Minecraft 1.13+"}).usage(new String[]{"see Minecraft tag expression"}).examples(new String[]{"set {_i} to minecraft tag \"doors\"", "set {_tag} to minecraft tag \"trapdoors\"", "set {_tags::*} to minecraft tags \"wall_signs\" and \"wooden_doors\"", "set {_tag} to \"minecraft:climbable\"", "", "loop minecraft tags:", "\tsend \"-%loop-value%\" to console"}).since("1.10.0").parser((Parser)new Parser<Tag>(){

                public boolean canParse(ParseContext context) {
                    return false;
                }

                public String toString(Tag tag, int flags) {
                    return tag.getKey().toString();
                }

                public String toVariableNameString(Tag tag) {
                    return "minecrafttag:" + this.toString(tag, 0);
                }

                public String getVariableNamePattern() {
                    return "minecrafttag://s";
                }
            }));
        }
    }
}

